/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.events;

import com.zutubi.pulse.core.Stoppable;
import com.zutubi.pulse.events.Event;
import com.zutubi.pulse.events.EventListener;
import com.zutubi.pulse.util.logging.Logger;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;

public class AsynchronousDelegatingListener
implements EventListener,
Stoppable {
    private static final Logger LOG = Logger.getLogger(AsynchronousDelegatingListener.class);
    private final ExecutorService executor;
    private final EventListener delegate;

    public AsynchronousDelegatingListener(EventListener delegate) {
        this.delegate = delegate;
        this.executor = Executors.newSingleThreadExecutor();
    }

    public void handleEvent(final Event event) {
        this.executor.execute(new Runnable(){

            public void run() {
                AsynchronousDelegatingListener.this.delegate.handleEvent(event);
            }
        });
    }

    public Class[] getHandledEvents() {
        return this.delegate.getHandledEvents();
    }

    public void stop(boolean force) {
        if (force) {
            this.executor.shutdownNow();
        } else {
            this.executor.shutdown();
            try {
                if (!this.executor.awaitTermination(600L, TimeUnit.SECONDS)) {
                    LOG.warning("Time out awaiting asynchronous listener termination");
                }
            }
            catch (InterruptedException e) {
                LOG.warning(e);
            }
        }
    }
}

