/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.core.model;

import com.zutubi.pulse.core.model.TestResult;

public class TestCaseResult
extends TestResult {
    private Status status;
    private String message;
    private long brokenSince = 0L;
    private long brokenNumber = 0L;
    private boolean fixed = false;

    public TestCaseResult() {
    }

    public TestCaseResult(String name) {
        this(name, -1L);
    }

    public TestCaseResult(String name, long duration) {
        this(name, duration, Status.PASS, null);
    }

    public TestCaseResult(String name, long duration, Status status, String message) {
        super(name, duration);
        this.status = status;
        this.message = message;
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public String getStatusName() {
        return this.status.toString();
    }

    public void setStatusName(String statusName) {
        this.status = Status.valueOf(statusName);
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public int getErrors() {
        return this.status == Status.ERROR ? 1 : 0;
    }

    public int getFailures() {
        return this.status == Status.FAILURE ? 1 : 0;
    }

    public int getTotal() {
        return 1;
    }

    public boolean isSuite() {
        return false;
    }

    public boolean wasBrokenPreviously() {
        return this.brokenSince != 0L;
    }

    public long getBrokenSince() {
        return this.brokenSince;
    }

    public void setBrokenSince(long brokenSince) {
        this.brokenSince = brokenSince;
    }

    public long getBrokenNumber() {
        return this.brokenNumber;
    }

    public void setBrokenNumber(long brokenNumber) {
        this.brokenNumber = brokenNumber;
    }

    public boolean isFixed() {
        return this.fixed;
    }

    public void setFixed(boolean fixed) {
        this.fixed = fixed;
    }

    public boolean isEquivalent(TestResult otherResult) {
        if (!(otherResult instanceof TestCaseResult)) {
            return false;
        }
        if (!super.isEquivalent(otherResult)) {
            return false;
        }
        TestCaseResult other = (TestCaseResult)otherResult;
        if (this.message == null ? other.message != null : !this.message.equals(other.message)) {
            return false;
        }
        return this.status == other.status;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Status {
        PASS,
        FAILURE,
        ERROR;

    }
}

