/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.core.model;

import com.zutubi.pulse.core.model.Entity;
import com.zutubi.pulse.core.model.TestCaseResult;

public class TestCaseIndex
extends Entity {
    private long projectId;
    private long specNameId;
    private long stageNameId;
    private String name;
    private int totalCount;
    private int failureCount;
    private int errorCount;
    private long brokenSince = 0L;
    private long brokenNumber = 0L;

    public TestCaseIndex() {
    }

    public TestCaseIndex(long projectId, long specNameId, long stageNameId, String name) {
        this.projectId = projectId;
        this.specNameId = specNameId;
        this.stageNameId = stageNameId;
        this.name = name;
    }

    public void recordExecution(TestCaseResult.Status status, long buildId, long buildNumber) {
        ++this.totalCount;
        switch (status) {
            case ERROR: {
                ++this.errorCount;
                this.checkBroken(buildId, buildNumber);
                break;
            }
            case FAILURE: {
                ++this.failureCount;
                this.checkBroken(buildId, buildNumber);
                break;
            }
            case PASS: {
                this.brokenSince = 0L;
                this.brokenNumber = 0L;
            }
        }
    }

    private void checkBroken(long buildId, long buildNumber) {
        if (this.isHealthy()) {
            this.brokenSince = buildId;
            this.brokenNumber = buildNumber;
        }
    }

    public long getProjectId() {
        return this.projectId;
    }

    public void setProjectId(long projectId) {
        this.projectId = projectId;
    }

    public long getSpecNameId() {
        return this.specNameId;
    }

    public void setSpecNameId(long specNameId) {
        this.specNameId = specNameId;
    }

    public long getStageNameId() {
        return this.stageNameId;
    }

    public void setStageNameId(long stageNameId) {
        this.stageNameId = stageNameId;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getTotalCount() {
        return this.totalCount;
    }

    public void setTotalCount(int totalCount) {
        this.totalCount = totalCount;
    }

    public int getFailureCount() {
        return this.failureCount;
    }

    public void setFailureCount(int failureCount) {
        this.failureCount = failureCount;
    }

    public int getErrorCount() {
        return this.errorCount;
    }

    public void setErrorCount(int errorCount) {
        this.errorCount = errorCount;
    }

    public boolean isHealthy() {
        return this.brokenSince == 0L;
    }

    public long getBrokenSince() {
        return this.brokenSince;
    }

    public void setBrokenSince(long brokenSince) {
        this.brokenSince = brokenSince;
    }

    public long getBrokenNumber() {
        return this.brokenNumber;
    }

    public void setBrokenNumber(long brokenNumber) {
        this.brokenNumber = brokenNumber;
    }
}

