/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.core.model;

import com.zutubi.pulse.core.model.Entity;
import com.zutubi.pulse.core.model.Feature;
import com.zutubi.pulse.core.model.PlainFeature;
import com.zutubi.pulse.util.FileSystemUtils;
import java.net.URLConnection;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StoredFileArtifact
extends Entity {
    public static final String TYPE_PLAIN = "text/plain";
    private String path;
    private String type;
    private List<Feature> features;

    public StoredFileArtifact() {
    }

    public StoredFileArtifact(String path) {
        this(path, null);
    }

    public StoredFileArtifact(String path, String type) {
        this.setPath(path);
        this.type = type;
        this.features = new LinkedList<Feature>();
    }

    public String getPath() {
        return this.path;
    }

    private void setPath(String path) {
        this.path = FileSystemUtils.normaliseSeparators(path);
    }

    public void addFeature(Feature feature) {
        this.features.add(feature);
    }

    public void addFeatures(List<Feature> features) {
        this.features.addAll(features);
    }

    public boolean hasFeatures() {
        return this.features.size() != 0;
    }

    public Iterable<Feature.Level> getLevels() {
        TreeSet<Feature.Level> levels = new TreeSet<Feature.Level>();
        for (Feature f : this.features) {
            levels.add(f.getLevel());
        }
        return levels;
    }

    public boolean hasMessages(Feature.Level level) {
        return this.getFeatures(level).size() > 0;
    }

    public List<Feature> getFeatures(Feature.Level level) {
        LinkedList<Feature> result = new LinkedList<Feature>();
        for (Feature f : this.features) {
            if (f.getLevel() != level) continue;
            result.add(f);
        }
        return result;
    }

    public String getType() {
        return this.type;
    }

    private void setType(String type) {
        this.type = type;
    }

    public List<Feature> getFeatures() {
        return this.features;
    }

    private void setFeatures(List<Feature> features) {
        this.features = features;
    }

    public boolean canDecorate() {
        String mimeType = this.type == null ? URLConnection.guessContentTypeFromName(this.path) : this.type;
        if (mimeType != null && mimeType.equals(TYPE_PLAIN)) {
            return true;
        }
        for (Feature f : this.features) {
            if (!(f instanceof PlainFeature)) continue;
            return true;
        }
        return false;
    }
}

