/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.core.model;

import com.zutubi.pulse.core.model.Entity;
import com.zutubi.pulse.core.model.ResourceProperty;
import com.zutubi.pulse.core.model.ResourceVersion;
import com.zutubi.pulse.model.NamedEntity;
import java.util.Map;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Resource
extends Entity
implements NamedEntity {
    private String name;
    private Map<String, ResourceProperty> properties = new TreeMap<String, ResourceProperty>();
    private String defaultVersion;
    private Map<String, ResourceVersion> versions = new TreeMap<String, ResourceVersion>();

    public Resource() {
    }

    public Resource(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean hasVersion(String value) {
        return this.versions.containsKey(value);
    }

    public ResourceVersion getVersion(String id) {
        return this.versions.get(id);
    }

    public ResourceVersion getVersion(long id) {
        for (ResourceVersion v : this.versions.values()) {
            if (v.getId() != id) continue;
            return v;
        }
        return null;
    }

    public String getDefaultVersion() {
        return this.defaultVersion;
    }

    public void setDefaultVersion(String defaultVersion) {
        this.defaultVersion = defaultVersion;
    }

    public Map<String, ResourceVersion> getVersions() {
        return this.versions;
    }

    public void setVersions(Map<String, ResourceVersion> versions) {
        this.versions = versions;
    }

    public void deleteVersion(ResourceVersion version) {
        if (version.getValue().equals(this.defaultVersion)) {
            this.defaultVersion = null;
        }
        this.versions.remove(version.getValue());
    }

    public Map<String, ResourceProperty> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, ResourceProperty> properties) {
        this.properties = properties;
    }

    public boolean hasProperty(String name) {
        return this.properties.containsKey(name);
    }

    public ResourceProperty getProperty(String name) {
        return this.properties.get(name);
    }

    public void addProperty(ResourceProperty p) {
        String name = p.getName();
        this.properties.put(name, p);
    }

    public void deleteProperty(String name) {
        this.properties.remove(name);
    }

    public void add(ResourceVersion v) {
        this.versions.put(v.getValue(), v);
    }

    public int getTotalPropertyCount() {
        int count = this.properties.size();
        for (ResourceVersion v : this.versions.values()) {
            count += v.getProperties().size();
        }
        return count;
    }

    public int getEmptyVersionCount() {
        int count = 0;
        if (this.properties.isEmpty()) {
            ++count;
        }
        for (ResourceVersion v : this.versions.values()) {
            if (!v.getProperties().isEmpty()) continue;
            ++count;
        }
        return count;
    }
}

