/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.core.model;

import com.zutubi.pulse.core.model.CommandResult;
import com.zutubi.pulse.core.model.Feature;
import com.zutubi.pulse.core.model.Result;
import com.zutubi.pulse.core.model.ResultState;
import com.zutubi.pulse.core.model.StoredArtifact;
import com.zutubi.pulse.core.model.TestResultSummary;
import com.zutubi.pulse.core.model.TestSuitePersister;
import com.zutubi.pulse.core.model.TestSuiteResult;
import com.zutubi.pulse.util.FileSystemUtils;
import com.zutubi.pulse.util.logging.Logger;
import java.io.File;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RecipeResult
extends Result {
    public static final String RECIPE_LOG = "recipe.log";
    public static final String TEST_DIR = "tests";
    private static final Logger LOG = Logger.getLogger(RecipeResult.class);
    private String recipeName;
    private List<CommandResult> results = new LinkedList<CommandResult>();
    private TestSuiteResult failedTestResults;
    private TestResultSummary testSummary = new TestResultSummary();

    public RecipeResult() {
        this.state = ResultState.INITIAL;
    }

    public RecipeResult(String recipeName) {
        this.recipeName = recipeName;
        this.state = ResultState.INITIAL;
    }

    public void commence(String recipeName, long startTime) {
        this.recipeName = recipeName;
        super.commence(startTime);
    }

    public void add(CommandResult result) {
        this.results.add(result);
        if (this.state != ResultState.ERROR) {
            switch (result.state) {
                case ERROR: {
                    this.error("Error executing command '" + result.getCommandName() + "'");
                    break;
                }
                case FAILURE: {
                    if (this.state == ResultState.FAILURE) break;
                    this.failure("Command '" + result.getCommandName() + "' failed");
                }
            }
        }
    }

    public void update(CommandResult result) {
        CommandResult currentResult = this.results.remove(this.results.size() - 1);
        result.setId(currentResult.getId());
        result.getStamps().setStartTime(currentResult.getStamps().getStartTime());
        this.add(result);
        File remoteDir = new File(FileSystemUtils.localiseSeparators(result.getOutputDir()));
        File localDir = new File(this.getOutputDir(), remoteDir.getName());
        result.setOutputDir(localDir.getPath());
    }

    public void update(RecipeResult result) {
        switch (result.state) {
            case ERROR: {
                this.state = ResultState.ERROR;
                break;
            }
            case FAILURE: {
                if (this.state == ResultState.ERROR) break;
                this.state = ResultState.FAILURE;
            }
        }
        this.features.addAll(result.features);
        this.testSummary = result.testSummary;
        this.stamps.setEndTime(result.stamps.getEndTime());
    }

    public List<CommandResult> getCommandResults() {
        return this.results;
    }

    private void setCommandResults(List<CommandResult> results) {
        this.results = results;
    }

    public String getRecipeName() {
        return this.recipeName;
    }

    public String getRecipeNameSafe() {
        return RecipeResult.getRecipeSafe(this.recipeName);
    }

    private void setRecipeName(String recipeName) {
        this.recipeName = recipeName;
    }

    public static String getRecipeSafe(String recipeName) {
        if (recipeName == null) {
            return "[default]";
        }
        return recipeName;
    }

    public void abortUnfinishedCommands() {
        for (CommandResult result : this.results) {
            if (result.completed()) continue;
            result.error("Build aborted");
            result.complete();
        }
    }

    @Override
    public List<String> collectErrors() {
        List<String> errors = super.collectErrors();
        for (CommandResult result : this.results) {
            errors.addAll(result.collectErrors());
        }
        return errors;
    }

    public boolean hasMessages(Feature.Level level) {
        if (this.hasDirectMessages(level)) {
            return true;
        }
        for (CommandResult result : this.results) {
            if (!result.hasMessages(level)) continue;
            return true;
        }
        return false;
    }

    public boolean hasArtifacts() {
        for (CommandResult result : this.results) {
            if (!result.hasArtifacts()) continue;
            return true;
        }
        return false;
    }

    public StoredArtifact getArtifact(String name) {
        for (CommandResult result : this.results) {
            StoredArtifact artifact = result.getArtifact(name);
            if (artifact == null) continue;
            return artifact;
        }
        return null;
    }

    public void accumulateTestSummary(TestResultSummary summary) {
        if (this.testSummary != null) {
            summary.add(this.testSummary);
        }
    }

    public CommandResult getCommandResult(String name) {
        for (CommandResult r : this.results) {
            if (!name.equals(r.getCommandName())) continue;
            return r;
        }
        return null;
    }

    public TestSuiteResult getFailedTestResults() {
        return this.failedTestResults;
    }

    public void setFailedTestResults(TestSuiteResult failedTestResults) {
        this.failedTestResults = failedTestResults;
    }

    public void loadFailedTestResults(File dataRoot, int limit) {
        File output = this.getAbsoluteOutputDir(dataRoot);
        File testDir = new File(output, TEST_DIR);
        if (testDir.exists()) {
            try {
                TestSuitePersister persister = new TestSuitePersister();
                this.failedTestResults = persister.read(null, testDir, true, true, limit);
            }
            catch (Exception e) {
                LOG.severe("Unable to load test results", e);
            }
        }
    }

    public int getExcessFailureCount() {
        int loadedCount = 0;
        if (this.failedTestResults != null) {
            loadedCount = this.failedTestResults.getSummary().getBroken();
        }
        return this.testSummary.getBroken() - loadedCount;
    }

    public TestResultSummary getTestSummary() {
        return this.testSummary;
    }

    public void setTestSummary(TestResultSummary testSummary) {
        this.testSummary = testSummary;
    }

    public boolean hasBrokenTests() {
        return this.testSummary != null && this.testSummary.getBroken() > 0;
    }

    @Override
    public void calculateFeatureCounts() {
        super.calculateFeatureCounts();
        for (CommandResult result : this.results) {
            result.calculateFeatureCounts();
            this.warningFeatureCount += result.getWarningFeatureCount();
            this.errorFeatureCount += result.getErrorFeatureCount();
        }
    }
}

