/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.core.model;

import com.zutubi.pulse.core.model.Change;
import com.zutubi.pulse.core.model.Entity;
import com.zutubi.pulse.core.model.Revision;
import com.zutubi.pulse.util.TimeStamps;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Changelist
extends Entity {
    private String serverUid;
    private Revision revision;
    private List<Change> changes;
    private List<Long> projectIds = new LinkedList<Long>();
    private List<Long> resultIds = new LinkedList<Long>();

    protected Changelist() {
    }

    public Changelist(String serverUid, Revision revision) {
        this.serverUid = serverUid;
        this.revision = revision;
        this.changes = new LinkedList<Change>();
    }

    public void addChange(Change change) {
        this.changes.add(change);
    }

    public String getServerUid() {
        return this.serverUid;
    }

    private void setServerUid(String serverUid) {
        this.serverUid = serverUid;
    }

    public Revision getRevision() {
        return this.revision;
    }

    public Date getDate() {
        return this.getRevision().getDate();
    }

    public String getPrettyTime() {
        return TimeStamps.getPrettyTime(this.getRevision().getDate().getTime());
    }

    public String getPrettyDate(Locale locale) {
        return TimeStamps.getPrettyDate(this.getRevision().getDate().getTime(), locale);
    }

    public String getUser() {
        return this.getRevision().getAuthor();
    }

    public String getComment() {
        return this.getRevision().getComment();
    }

    public List<Change> getChanges() {
        return this.changes;
    }

    private void setChanges(List<Change> changes) {
        this.changes = changes;
    }

    private void setRevision(Revision revision) {
        this.revision = revision;
    }

    public List<Long> getProjectIds() {
        return this.projectIds;
    }

    public void setProjectIds(List<Long> projectIds) {
        this.projectIds = projectIds;
    }

    public List<Long> getResultIds() {
        return this.resultIds;
    }

    public void setResultIds(List<Long> resultIds) {
        this.resultIds = resultIds;
    }

    public void addProjectId(long id) {
        if (!this.projectIds.contains(id)) {
            this.projectIds.add(id);
        }
    }

    public void addResultId(long id) {
        this.resultIds.add(id);
    }

    public void removeResultId(long id) {
        int i;
        for (i = 0; i < this.resultIds.size() && this.resultIds.get(i) != id; ++i) {
        }
        if (i < this.resultIds.size()) {
            this.resultIds.remove(i);
        }
    }

    public String toString() {
        return "{ uid: " + this.serverUid + ", rev: " + this.revision.toString() + ", changes: " + this.changes.toString() + " }";
    }
}

