/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.core.model;

import com.zutubi.pulse.core.model.Entity;
import com.zutubi.pulse.core.model.FileRevision;

public class Change
extends Entity {
    private String filename;
    private FileRevision revision;
    private Action action;

    protected Change() {
    }

    public Change(String filename, FileRevision revision, Action action) {
        this.filename = filename;
        this.revision = revision;
        this.action = action;
    }

    public String getFilename() {
        return this.filename;
    }

    public FileRevision getRevision() {
        return this.revision;
    }

    public Action getAction() {
        return this.action;
    }

    private void setFilename(String filename) {
        this.filename = filename;
    }

    private void setRevision(FileRevision revision) {
        this.revision = revision;
    }

    private String getActionName() {
        return this.action.toString();
    }

    private void setActionName(String action) {
        this.action = Action.valueOf(action);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.filename);
        if (this.revision != null) {
            buffer.append("#").append(this.revision);
        }
        if (this.action != null) {
            buffer.append("-").append(this.action.toString());
        }
        return buffer.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Action {
        ADD{

            public String getPrettyString() {
                return "added";
            }
        }
        ,
        BRANCH{

            public String getPrettyString() {
                return "branched";
            }
        }
        ,
        DELETE{

            public String getPrettyString() {
                return "deleted";
            }
        }
        ,
        EDIT{

            public String getPrettyString() {
                return "edited";
            }
        }
        ,
        INTEGRATE{

            public String getPrettyString() {
                return "integrated";
            }
        }
        ,
        MERGE{

            public String getPrettyString() {
                return "merged";
            }
        }
        ,
        MOVE{

            public String getPrettyString() {
                return "moved";
            }
        }
        ,
        UNKNOWN{

            public String getPrettyString() {
                return "unknown";
            }
        };


        public abstract String getPrettyString();
    }
}

