/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.core;

import com.opensymphony.util.TextUtils;
import com.zutubi.pulse.core.CommandContext;
import com.zutubi.pulse.core.ExecutableCommand;
import com.zutubi.pulse.core.Reference;
import com.zutubi.pulse.core.Scope;
import com.zutubi.pulse.core.XCodePostProcessor;
import com.zutubi.pulse.core.model.CommandResult;
import com.zutubi.pulse.core.model.StoredArtifact;
import com.zutubi.pulse.util.StringUtils;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XCodeCommand
extends ExecutableCommand {
    private String target;
    private String config;
    private String project;
    private String buildaction;
    private List<String> settings;

    private void checkExe() {
        if (this.getExe() == null) {
            Reference ref;
            Scope scope = this.getScope();
            if (scope != null && (ref = scope.getReference("xcode.bin")) != null && ref.getValue() instanceof String) {
                this.setExe((String)ref.getValue());
            }
            if (this.getExe() == null) {
                this.setExe("xcodebuild");
            }
        }
    }

    @Override
    public void execute(CommandContext context, CommandResult cmdResult) {
        this.checkExe();
        if (TextUtils.stringSet((String)this.project)) {
            this.addArguments("-project", this.project);
            cmdResult.getProperties().put("project", this.project);
        }
        if (TextUtils.stringSet((String)this.config)) {
            this.addArguments("-configuration", this.config);
            cmdResult.getProperties().put("configuration", this.config);
        }
        if (TextUtils.stringSet((String)this.target)) {
            this.addArguments("-target", this.target);
            cmdResult.getProperties().put("target", this.target);
        }
        if (TextUtils.stringSet((String)this.buildaction)) {
            this.addArguments(this.buildaction);
            cmdResult.getProperties().put("build action", this.buildaction);
        }
        if (this.settings != null && this.settings.size() > 0) {
            this.addArguments(this.settings.toArray(new String[this.settings.size()]));
            cmdResult.getProperties().put("settings", StringUtils.unsplit(this.settings));
        }
        super.execute(context, cmdResult);
        StoredArtifact artifact = cmdResult.getArtifact("command output");
        if (artifact != null) {
            XCodePostProcessor pp = new XCodePostProcessor("xcode.pp");
            pp.process(artifact.getFile(), cmdResult, context);
        }
    }

    public String getTarget() {
        return this.target;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public String getConfig() {
        return this.config;
    }

    public void setConfig(String config) {
        this.config = config;
    }

    public String getProject() {
        return this.project;
    }

    public void setProject(String project) {
        this.project = project;
    }

    public String getBuildaction() {
        return this.buildaction;
    }

    public void setBuildaction(String buildaction) {
        this.buildaction = buildaction;
    }

    public List<String> getSettings() {
        return this.settings;
    }

    public void setSettings(List<String> settings) {
        this.settings = settings;
    }

    @Override
    public void setScope(Scope scope) {
        super.setScope(scope);
        this.checkExe();
    }
}

