/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.core;

import com.zutubi.pulse.core.PulseFile;
import com.zutubi.pulse.core.Recipe;
import com.zutubi.pulse.core.ResourceReference;
import com.zutubi.pulse.core.TypeLoadPredicate;
import java.util.LinkedList;
import java.util.List;
import nu.xom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceRequirementsPredicate
implements TypeLoadPredicate {
    private PulseFile pulseFile;
    private String recipeName;
    private List<ResourceReference> references;

    public ResourceRequirementsPredicate(PulseFile pulseFile, String recipeName) {
        this.pulseFile = pulseFile;
        this.recipeName = recipeName;
        this.references = new LinkedList<ResourceReference>();
    }

    @Override
    public boolean loadType(Object type, Element element) {
        if (type instanceof Recipe) {
            if (this.recipeName == null) {
                this.recipeName = this.pulseFile.getDefaultRecipe();
            }
            if (this.recipeName == null) {
                return false;
            }
            Recipe recipe = (Recipe)type;
            return recipe.getName().equals(this.recipeName);
        }
        if (type instanceof ResourceReference) {
            this.references.add((ResourceReference)type);
        }
        return false;
    }

    @Override
    public boolean resolveReferences(Object type, Element element) {
        return type instanceof ResourceReference;
    }

    public List<ResourceReference> getReferences() {
        return this.references;
    }
}

