/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.core;

import com.opensymphony.util.TextUtils;
import com.zutubi.pulse.core.FileLoadException;
import com.zutubi.pulse.core.InitComponent;
import com.zutubi.pulse.core.ResourceAware;
import com.zutubi.pulse.core.ResourceRepository;
import com.zutubi.pulse.core.Scope;
import com.zutubi.pulse.core.ScopeAware;
import com.zutubi.pulse.core.model.Resource;
import com.zutubi.pulse.core.model.ResourceVersion;

public class ResourceReference
implements ResourceAware,
ScopeAware,
InitComponent {
    private String name;
    private String version;
    private boolean required = true;
    private ResourceRepository repository;
    private Scope scope;

    public void setScope(Scope scope) {
        this.scope = scope;
    }

    public void initBeforeChildren() throws FileLoadException {
        Resource resource = null;
        if (this.repository != null) {
            resource = this.repository.getResource(this.name);
        }
        if (resource == null) {
            if (this.required) {
                throw new FileLoadException("Reference to undefined resource '" + this.name + "'");
            }
            return;
        }
        this.scope.getParent().add(resource.getProperties().values());
        String importVersion = this.version;
        if (importVersion == null) {
            importVersion = resource.getDefaultVersion();
        }
        if (TextUtils.stringSet((String)importVersion)) {
            ResourceVersion resourceVersion = resource.getVersion(importVersion);
            if (resourceVersion == null) {
                if (this.required) {
                    throw new FileLoadException("Reference to undefined version '" + importVersion + "' of resource '" + this.name + "'");
                }
                return;
            }
            this.scope.getParent().add(resourceVersion.getProperties().values());
        }
    }

    public void initAfterChildren() {
    }

    public void setResourceRepository(ResourceRepository repo) {
        this.repository = repo;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public boolean isRequired() {
        return this.required;
    }

    public void setRequired(boolean required) {
        this.required = required;
    }
}

