/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.core;

import com.zutubi.pulse.core.FileLoadException;
import com.zutubi.pulse.core.TestReportPostProcessor;
import com.zutubi.pulse.core.model.CommandResult;
import com.zutubi.pulse.core.model.TestCaseResult;
import com.zutubi.pulse.core.model.TestSuiteResult;
import com.zutubi.pulse.util.IOUtils;
import com.zutubi.pulse.util.logging.Logger;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RegexTestPostProcessor
extends TestReportPostProcessor {
    private static final Logger LOG = Logger.getLogger(RegexTestPostProcessor.class);
    private BufferedReader reader;
    private String currentLine;
    private String regex;
    private int statusGroup;
    private int nameGroup;
    private boolean autoFail = false;
    private boolean trim = true;
    private Resolution resolveConflicts = Resolution.OFF;
    private Map<String, TestCaseResult.Status> statusMap = new HashMap<String, TestCaseResult.Status>();

    public RegexTestPostProcessor() {
        this.statusMap.put("PASS", TestCaseResult.Status.PASS);
        this.statusMap.put("FAILURE", TestCaseResult.Status.FAILURE);
        this.statusMap.put("ERROR", TestCaseResult.Status.ERROR);
    }

    public RegexTestPostProcessor(String name) {
        this.setName(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void internalProcess(CommandResult result, File file, TestSuiteResult suite) {
        if (this.trim) {
            this.regex = this.regex.trim();
        }
        try {
            this.reader = new BufferedReader(new FileReader(file));
            try {
                this.processFile(suite);
            }
            catch (IllegalStateException e) {
                LOG.info(e);
            }
        }
        catch (IOException e) {
            LOG.info(e);
        }
        finally {
            IOUtils.close(this.reader);
        }
    }

    private void processFile(TestSuiteResult tests) throws IOException {
        Pattern pattern = Pattern.compile(this.regex);
        this.currentLine = this.nextLine();
        while (this.currentLine != null) {
            Matcher m = pattern.matcher(this.currentLine);
            if (m.matches()) {
                String statusString = m.group(this.statusGroup);
                if (this.autoFail || this.statusMap.containsKey(statusString)) {
                    String testName = m.group(this.nameGroup);
                    TestCaseResult result = new TestCaseResult();
                    result.setName(testName);
                    TestCaseResult.Status status = this.statusMap.get(statusString);
                    if (status == null) {
                        status = TestCaseResult.Status.FAILURE;
                    }
                    result.setStatus(status);
                    if (this.resolveConflicts != Resolution.OFF && tests.hasCase(result.getName())) {
                        int addition = 2;
                        while (tests.hasCase(this.makeCaseName(result.getName(), addition, this.resolveConflicts))) {
                            ++addition;
                        }
                        result.setName(this.makeCaseName(result.getName(), addition, this.resolveConflicts));
                    }
                    tests.add(result);
                } else {
                    LOG.warning("Test with unrecognised status '" + statusString + "'");
                }
            }
            this.currentLine = this.nextLine();
        }
    }

    private String nextLine() throws IOException {
        this.currentLine = this.reader.readLine();
        return this.currentLine;
    }

    private String makeCaseName(String name, int addition, Resolution resolveConflicts) {
        if (resolveConflicts == Resolution.APPEND) {
            return name + addition;
        }
        return Integer.toString(addition) + name;
    }

    public void setRegex(String regex) {
        this.regex = regex;
    }

    public String getRegex() {
        return this.regex;
    }

    public void setStatusGroup(int i) {
        this.statusGroup = i;
    }

    public int getStatusGroup() {
        return this.statusGroup;
    }

    public void setNameGroup(int i) {
        this.nameGroup = i;
    }

    public int getNameGroup() {
        return this.nameGroup;
    }

    public String getPassStatus() {
        for (Map.Entry<String, TestCaseResult.Status> entry : this.statusMap.entrySet()) {
            if (!entry.getValue().equals((Object)TestCaseResult.Status.PASS)) continue;
            return entry.getKey();
        }
        return null;
    }

    public void setPassStatus(String status) {
        this.statusMap.put(status, TestCaseResult.Status.PASS);
    }

    public String getFailureStatus() {
        for (Map.Entry<String, TestCaseResult.Status> entry : this.statusMap.entrySet()) {
            if (!entry.getValue().equals((Object)TestCaseResult.Status.FAILURE)) continue;
            return entry.getKey();
        }
        return null;
    }

    public void setFailureStatus(String status) {
        this.statusMap.put(status, TestCaseResult.Status.FAILURE);
    }

    public void setText(String txt) {
        this.regex = txt;
    }

    public void setAutoFail(boolean autoFail) {
        this.autoFail = autoFail;
    }

    public void setTrim(boolean trim) {
        this.trim = trim;
    }

    public Resolution getResolveConflicts() {
        return this.resolveConflicts;
    }

    public void setResolveConflicts(String resolution) throws FileLoadException {
        try {
            this.resolveConflicts = Resolution.valueOf(resolution.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            throw new FileLoadException("Unrecognised conflict resolution '" + resolution + "'");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Resolution {
        APPEND,
        OFF,
        PREPEND;

    }
}

