/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.core;

import com.zutubi.pulse.core.CommandContext;
import com.zutubi.pulse.core.PostProcessor;
import com.zutubi.pulse.core.RegexPattern;
import com.zutubi.pulse.core.model.CommandResult;
import com.zutubi.pulse.core.model.Feature;
import com.zutubi.pulse.core.model.PlainFeature;
import com.zutubi.pulse.core.model.StoredFileArtifact;
import com.zutubi.pulse.util.CircularBuffer;
import com.zutubi.pulse.util.IOUtils;
import com.zutubi.pulse.util.logging.Logger;
import com.zutubi.validation.Validateable;
import com.zutubi.validation.ValidationContext;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RegexPostProcessor
implements PostProcessor,
Validateable {
    private static final Logger LOG = Logger.getLogger(RegexPostProcessor.class.getName());
    private String name;
    private List<RegexPattern> patterns;
    private boolean failOnError = true;
    private boolean failOnWarning = false;
    private int leadingContext = 0;
    private int trailingContext = 0;
    private boolean joinOverlapping = true;

    public RegexPostProcessor() {
        this.patterns = new LinkedList<RegexPattern>();
    }

    public RegexPostProcessor(String name) {
        this.name = name;
        this.patterns = new LinkedList<RegexPattern>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public void process(StoredFileArtifact artifact, CommandResult result, CommandContext context) {
        LinkedList<PlainFeature> features;
        block10: {
            BufferedReader reader;
            features = new LinkedList<PlainFeature>();
            if (this.leadingContext == 0 && this.trailingContext == 0) {
                this.simpleProcess(context.getOutputDir(), artifact, result, features);
            } else {
                String next;
                String line;
                reader = null;
                File file = new File(context.getOutputDir(), artifact.getPath());
                reader = new BufferedReader(new FileReader(file));
                long lineNumber = 0L;
                CircularBuffer<String> trailingBuffer = new CircularBuffer<String>(this.trailingContext + 1);
                for (int i = 0; i <= this.trailingContext && (line = reader.readLine()) != null; ++i) {
                    trailingBuffer.append(line);
                }
                CircularBuffer<String> leadingBuffer = new CircularBuffer<String>(this.leadingContext);
                while ((next = reader.readLine()) != null) {
                    line = (String)trailingBuffer.getElement(0);
                    this.processLine(features, result, line, ++lineNumber, leadingBuffer, trailingBuffer, 1);
                    leadingBuffer.append(line);
                    trailingBuffer.append(next);
                }
                for (int i = 0; i < trailingBuffer.getCount(); ++i) {
                    line = (String)trailingBuffer.getElement(i);
                    this.processLine(features, result, line, ++lineNumber, leadingBuffer, trailingBuffer, i + 1);
                    leadingBuffer.append(line);
                }
                IOUtils.close(reader);
            }
            break block10;
            catch (IOException e) {
                try {
                    LOG.warning("I/O error post-processing artifact '" + artifact.getPath() + "': " + e.getMessage());
                }
                catch (Throwable throwable) {
                    IOUtils.close(reader);
                    throw throwable;
                }
                IOUtils.close(reader);
            }
        }
        for (PlainFeature f : features) {
            artifact.addFeature(f);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void simpleProcess(File outputDir, StoredFileArtifact artifact, CommandResult result, List<PlainFeature> features) {
        BufferedReader reader = null;
        try {
            String line;
            File file = new File(outputDir, artifact.getPath());
            reader = new BufferedReader(new FileReader(file));
            long lineNumber = 0L;
            while ((line = reader.readLine()) != null) {
                this.processLine(features, result, line, ++lineNumber);
            }
        }
        catch (IOException e) {
            try {
                LOG.warning("I/O error post-processing artifact '" + artifact.getPath() + "': " + e.getMessage());
            }
            catch (Throwable throwable) {
                IOUtils.close(reader);
                throw throwable;
            }
            IOUtils.close(reader);
        }
        IOUtils.close(reader);
    }

    private void processLine(List<PlainFeature> features, CommandResult result, String line, long lineNumber) {
        this.processLine(features, result, line, lineNumber, null, null, 0);
    }

    private void processLine(List<PlainFeature> features, CommandResult result, String line, long lineNumber, CircularBuffer<String> leadingContext, CircularBuffer<String> trailingContext, int trailingIndex) {
        for (RegexPattern p : this.patterns) {
            String summary = p.match(line);
            if (summary == null) continue;
            if (p.getCategory() == Feature.Level.ERROR && this.failOnError) {
                result.failure("Error features detected");
            } else if (p.getCategory() == Feature.Level.WARNING && this.failOnWarning) {
                result.failure("Warning features detected");
            }
            if (leadingContext == null) {
                this.addFeature(features, new PlainFeature(p.getCategory(), summary, lineNumber));
                continue;
            }
            StringBuilder summaryBuilder = new StringBuilder();
            this.append(summaryBuilder, leadingContext, 0, true);
            summaryBuilder.append(summary);
            this.append(summaryBuilder, trailingContext, trailingIndex, false);
            this.addFeature(features, new PlainFeature(p.getCategory(), summaryBuilder.toString(), lineNumber - (long)leadingContext.getCount(), lineNumber + (long)trailingContext.getCount() - (long)trailingIndex, lineNumber));
        }
    }

    private void addFeature(List<PlainFeature> features, PlainFeature feature) {
        if (this.canJoin(features, feature)) {
            PlainFeature previous = features.get(features.size() - 1);
            long overlappingLines = previous.getLastLine() - feature.getFirstLine() + 1L;
            String remainingSummary = this.getRemainingSummary(feature.getSummary(), overlappingLines);
            previous.setSummary(previous.getSummary() + remainingSummary);
            previous.setLastLine(feature.getLastLine());
        } else {
            features.add(feature);
        }
    }

    private boolean canJoin(List<PlainFeature> features, PlainFeature feature) {
        if (this.joinOverlapping && features.size() > 0) {
            PlainFeature previous = features.get(features.size() - 1);
            return previous.getLevel() == feature.getLevel() && previous.getLastLine() >= feature.getFirstLine();
        }
        return false;
    }

    private String getRemainingSummary(String summary, long overlappingLines) {
        StringBuilder result = new StringBuilder(summary.length());
        BufferedReader reader = new BufferedReader(new StringReader(summary));
        int lineNumber = 1;
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                if ((long)lineNumber++ <= overlappingLines) continue;
                result.append('\n');
                result.append(line);
            }
        }
        catch (IOException e) {
            return summary;
        }
        return result.toString();
    }

    private void append(StringBuilder builder, CircularBuffer<String> context, int i, boolean leading) {
        while (i < context.getCount()) {
            if (!leading) {
                builder.append('\n');
            }
            builder.append(context.getElement(i));
            if (leading) {
                builder.append('\n');
            }
            ++i;
        }
    }

    public RegexPattern createPattern() {
        RegexPattern pattern = new RegexPattern();
        this.addRegexPattern(pattern);
        return pattern;
    }

    public void addRegexPattern(RegexPattern pattern) {
        this.patterns.add(pattern);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Object getValue() {
        return this;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<RegexPattern> getPatterns() {
        return this.patterns;
    }

    public boolean getFailOnError() {
        return this.failOnError;
    }

    public void setFailOnError(boolean failOnError) {
        this.failOnError = failOnError;
    }

    public boolean getFailOnWarning() {
        return this.failOnWarning;
    }

    public void setFailOnWarning(boolean failOnWarning) {
        this.failOnWarning = failOnWarning;
    }

    public int getLeadingContext() {
        return this.leadingContext;
    }

    public void setLeadingContext(int leadingContext) {
        this.leadingContext = leadingContext;
    }

    public int getTrailingContext() {
        return this.trailingContext;
    }

    public void setTrailingContext(int trailingContext) {
        this.trailingContext = trailingContext;
    }

    public void setJoinOverlapping(boolean joinOverlapping) {
        this.joinOverlapping = joinOverlapping;
    }

    @Override
    public void validate(ValidationContext context) {
        if (this.leadingContext < 0) {
            context.addFieldError("leadingContext", "Leading context count must be non-negative (got " + this.leadingContext + ")");
        }
        if (this.trailingContext < 0) {
            context.addFieldError("trailingContext", "Trailing context count must be non-negative (got " + this.trailingContext + ")");
        }
    }

    protected void addErrorRegexs(String[] errorRegexs) {
        for (String errorRegex : errorRegexs) {
            RegexPattern pattern = this.createPattern();
            pattern.setPattern(Pattern.compile(errorRegex));
            pattern.setCategory(Feature.Level.ERROR);
        }
    }

    protected void addWarningRegexs(String[] warningRegexs) {
        for (String warningRegex : warningRegexs) {
            RegexPattern pattern = this.createPattern();
            pattern.setPattern(Pattern.compile(warningRegex));
            pattern.setCategory(Feature.Level.WARNING);
        }
    }
}

