/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.core;

import com.zutubi.pulse.core.AntCommand;
import com.zutubi.pulse.core.AntPostProcessor;
import com.zutubi.pulse.core.CommandGroup;
import com.zutubi.pulse.core.ComponentDefinition;
import com.zutubi.pulse.core.CppUnitReportPostProcessor;
import com.zutubi.pulse.core.ExecutableCommand;
import com.zutubi.pulse.core.FileLoader;
import com.zutubi.pulse.core.FileResourceRepository;
import com.zutubi.pulse.core.JUnitReportPostProcessor;
import com.zutubi.pulse.core.JUnitSummaryPostProcessor;
import com.zutubi.pulse.core.MakeCommand;
import com.zutubi.pulse.core.MakePostProcessor;
import com.zutubi.pulse.core.Maven2Command;
import com.zutubi.pulse.core.Maven2PostProcessor;
import com.zutubi.pulse.core.MavenCommand;
import com.zutubi.pulse.core.MavenPostProcessor;
import com.zutubi.pulse.core.OCUnitReportPostProcessor;
import com.zutubi.pulse.core.PostProcessorGroup;
import com.zutubi.pulse.core.PrintCommand;
import com.zutubi.pulse.core.PulseException;
import com.zutubi.pulse.core.PulseFile;
import com.zutubi.pulse.core.Recipe;
import com.zutubi.pulse.core.RegexPostProcessor;
import com.zutubi.pulse.core.RegexTestPostProcessor;
import com.zutubi.pulse.core.ResourceReference;
import com.zutubi.pulse.core.ResourceRequirementsPredicate;
import com.zutubi.pulse.core.Scope;
import com.zutubi.pulse.core.SleepCommand;
import com.zutubi.pulse.core.XCodeCommand;
import com.zutubi.pulse.core.XCodePostProcessor;
import com.zutubi.pulse.core.model.Property;
import com.zutubi.pulse.model.ResourceRequirement;
import java.io.ByteArrayInputStream;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PulseFileLoader
extends FileLoader {
    public PulseFileLoader() {
        this.register("property", Property.class);
        this.register("recipe", Recipe.class);
        this.register("def", ComponentDefinition.class);
        this.register("post-processor", PostProcessorGroup.class);
        this.register("command", CommandGroup.class);
        this.register("ant.pp", AntPostProcessor.class);
        this.register("cppunit.pp", CppUnitReportPostProcessor.class);
        this.register("junit.pp", JUnitReportPostProcessor.class);
        this.register("junit.summary.pp", JUnitSummaryPostProcessor.class);
        this.register("ocunit.pp", OCUnitReportPostProcessor.class);
        this.register("regex-test.pp", RegexTestPostProcessor.class);
        this.register("make.pp", MakePostProcessor.class);
        this.register("maven.pp", MavenPostProcessor.class);
        this.register("maven2.pp", Maven2PostProcessor.class);
        this.register("regex.pp", RegexPostProcessor.class);
        this.register("xcodebuild.pp", XCodePostProcessor.class);
        this.register("ant", AntCommand.class);
        this.register("maven", MavenCommand.class);
        this.register("maven2", Maven2Command.class);
        this.register("executable", ExecutableCommand.class);
        this.register("print", PrintCommand.class);
        this.register("sleep", SleepCommand.class);
        this.register("make", MakeCommand.class);
        this.register("xcodebuild", XCodeCommand.class);
        this.register("resource", ResourceReference.class);
    }

    public List<ResourceRequirement> loadRequiredResources(String pulseFile, String recipe) throws PulseException {
        LinkedList<ResourceRequirement> requirements = new LinkedList<ResourceRequirement>();
        PulseFile file = new PulseFile();
        ResourceRequirementsPredicate predicate = new ResourceRequirementsPredicate(file, recipe);
        this.load(new ByteArrayInputStream(pulseFile.getBytes()), file, new Scope(), new FileResourceRepository(), predicate);
        for (ResourceReference reference : predicate.getReferences()) {
            if (!reference.isRequired()) continue;
            requirements.add(new ResourceRequirement(reference.getName(), reference.getVersion()));
        }
        return requirements;
    }
}

