/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.core;

import com.zutubi.pulse.core.BuildException;
import com.zutubi.pulse.core.CommandContext;
import com.zutubi.pulse.core.CommandSupport;
import com.zutubi.pulse.core.ProcessArtifact;
import com.zutubi.pulse.core.ProcessSupport;
import com.zutubi.pulse.core.model.CommandResult;
import com.zutubi.pulse.util.IOUtils;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.LinkedList;
import java.util.List;

public class PrintCommand
extends CommandSupport {
    private String message;
    private boolean addNewline = true;
    private List<ProcessArtifact> processes = new LinkedList<ProcessArtifact>();
    private boolean terminated = false;

    public void execute(CommandContext context, CommandResult result) {
        if (this.terminated) {
            result.error("Terminated");
            return;
        }
        File outputFileDir = new File(context.getOutputDir(), "command output");
        if (!outputFileDir.mkdir()) {
            throw new BuildException("Unable to create directory for output artifact '" + outputFileDir.getAbsolutePath() + "'");
        }
        File outputFile = new File(outputFileDir, "output.txt");
        PrintWriter writer = null;
        try {
            writer = new PrintWriter(outputFile);
            writer.write(this.message);
            if (this.addNewline) {
                writer.println();
            }
        }
        catch (IOException e) {
            try {
                throw new BuildException(e);
            }
            catch (Throwable throwable) {
                IOUtils.close(writer);
                throw throwable;
            }
        }
        IOUtils.close(writer);
        ProcessSupport.postProcess(this.processes, outputFileDir, outputFile, result, context);
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void setAddNewLine(boolean addNewline) {
        this.addNewline = addNewline;
    }

    public ProcessArtifact createProcess() {
        ProcessArtifact p = new ProcessArtifact();
        this.processes.add(p);
        return p;
    }

    public void terminate() {
        this.terminated = true;
    }
}

