/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.core;

import com.opensymphony.util.ClassLoaderUtil;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectFactory {
    private final Map<String, Class> classes = new HashMap<String, Class>();

    public Class getClassInstance(String className) throws ClassNotFoundException {
        Class clazz = this.classes.get(className);
        if (clazz == null) {
            clazz = ClassLoaderUtil.loadClass((String)className, this.getClass());
            this.classes.put(className, clazz);
        }
        return clazz;
    }

    public <V> V buildBean(Class clazz) throws Exception {
        return (V)clazz.newInstance();
    }

    public <U> U buildBean(String className) throws Exception {
        Class clazz = this.getClassInstance(className);
        return (U)clazz.newInstance();
    }

    public <W> W buildBean(Class clazz, Class[] argTypes, Object[] args) throws Exception {
        Constructor constructor = clazz.getConstructor(argTypes);
        if (constructor != null) {
            return (W)constructor.newInstance(args);
        }
        throw new RuntimeException(String.format("Failed to locate the requested constructor for '%s'", clazz.getName()));
    }

    public <X> X buildBean(String className, Class[] argTypes, Object[] args) throws Exception {
        Class clazz = this.getClassInstance(className);
        Constructor constructor = clazz.getConstructor(argTypes);
        if (constructor != null) {
            return (X)constructor.newInstance(args);
        }
        throw new RuntimeException(String.format("Failed to locate the requested constructor for '%s'", clazz.getName()));
    }

    private Class[] toClassArray(Object ... objArray) {
        LinkedList classes = new LinkedList();
        for (Object obj : objArray) {
            if (obj != null) {
                classes.add(obj.getClass());
                continue;
            }
            classes.add(null);
        }
        return classes.toArray(new Class[classes.size()]);
    }
}

