/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.core;

import com.zutubi.pulse.core.TestReportPostProcessor;
import com.zutubi.pulse.core.model.CommandResult;
import com.zutubi.pulse.core.model.TestCaseResult;
import com.zutubi.pulse.core.model.TestSuiteResult;
import com.zutubi.pulse.util.IOUtils;
import com.zutubi.pulse.util.logging.Logger;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class OCUnitReportPostProcessor
extends TestReportPostProcessor {
    private static final Logger LOG = Logger.getLogger(OCUnitReportPostProcessor.class);
    private BufferedReader reader;
    private String currentLine;
    private static final Pattern START_SUITE_PATTERN = Pattern.compile("Test Suite '(.*?)' started at (.*$)");
    private static final Pattern END_SUITE_PATTERN = Pattern.compile("Test Suite '(.*?)' finished at (.*$)");
    private static final Pattern SUITE_SUMMARY_PATTERN = Pattern.compile("Executed (\\d*) test[s]?, with (\\d*) failure[s]? \\((\\d*) unexpected\\) in (\\d*\\.\\d*) \\((\\d*\\.\\d*)\\) second[s]?$");
    private static final Pattern CASE_SUMMARY_PATTERN = Pattern.compile("Test Case '-\\[(.*?) (.*?)\\]' (.*?) \\((\\d*\\.\\d*) second[s]?\\)\\.$");

    public OCUnitReportPostProcessor() {
    }

    public OCUnitReportPostProcessor(String name) {
        this.setName(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void internalProcess(CommandResult result, File file, TestSuiteResult suite) {
        try {
            this.reader = new BufferedReader(new FileReader(file));
            try {
                this.processFile(suite);
            }
            catch (IllegalStateException e) {
                LOG.info(e);
            }
        }
        catch (IOException e) {
            LOG.info(e);
        }
        finally {
            IOUtils.close(this.reader);
        }
    }

    private void processFile(TestSuiteResult tests) throws IOException {
        this.currentLine = this.nextLine();
        while (this.currentLine != null) {
            if (START_SUITE_PATTERN.matcher(this.currentLine).matches()) {
                tests.add(this.processSuite());
            }
            this.currentLine = this.nextLine();
        }
    }

    private TestSuiteResult processSuite() throws IOException {
        Matcher m = START_SUITE_PATTERN.matcher(this.currentLine);
        if (!m.matches()) {
            throw new IllegalStateException();
        }
        TestSuiteResult suite = new TestSuiteResult(m.group(1));
        this.currentLine = this.nextLine();
        String caseOutput = "";
        while (!END_SUITE_PATTERN.matcher(this.currentLine).matches()) {
            if (START_SUITE_PATTERN.matcher(this.currentLine).matches()) {
                suite.add(this.processSuite());
            } else if (CASE_SUMMARY_PATTERN.matcher(this.currentLine).matches()) {
                Matcher caseMatch = CASE_SUMMARY_PATTERN.matcher(this.currentLine);
                caseMatch.matches();
                TestCaseResult result = new TestCaseResult(caseMatch.group(2));
                result.setMessage(caseOutput);
                String statusString = caseMatch.group(3);
                if (statusString.compareTo("passed") == 0) {
                    result.setStatus(TestCaseResult.Status.PASS);
                } else if (statusString.compareTo("failed") == 0) {
                    result.setStatus(TestCaseResult.Status.FAILURE);
                }
                result.setDuration((long)(Double.parseDouble(caseMatch.group(4)) * 1000.0));
                suite.add(result);
                caseOutput = "";
            } else {
                caseOutput = caseOutput + this.currentLine;
            }
            this.currentLine = this.nextLine();
        }
        m = END_SUITE_PATTERN.matcher(this.currentLine);
        if (!m.matches()) {
            throw new IllegalStateException();
        }
        if (m.group(1).compareTo(suite.getName()) != 0) {
            throw new IllegalStateException();
        }
        this.currentLine = this.nextLine();
        m = SUITE_SUMMARY_PATTERN.matcher(this.currentLine);
        while (!m.matches()) {
            this.currentLine = this.nextLine();
            m = SUITE_SUMMARY_PATTERN.matcher(this.currentLine);
        }
        suite.setDuration((long)(Double.parseDouble(m.group(4)) * 1000.0));
        return suite;
    }

    private String nextLine() throws IOException {
        this.currentLine = this.reader.readLine();
        return this.currentLine;
    }
}

