/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.core;

import com.zutubi.pulse.core.CommandContext;
import com.zutubi.pulse.core.ExecutableCommand;
import com.zutubi.pulse.core.MavenPostProcessor;
import com.zutubi.pulse.core.MavenUtils;
import com.zutubi.pulse.core.Reference;
import com.zutubi.pulse.core.Scope;
import com.zutubi.pulse.core.model.CommandResult;
import com.zutubi.pulse.core.model.StoredArtifact;
import com.zutubi.pulse.util.SystemUtils;
import java.io.File;

public class MavenCommand
extends ExecutableCommand {
    private String targets;

    private void checkExe() {
        if (this.getExe() == null) {
            Reference ref;
            Scope scope = this.getScope();
            if (scope != null && (ref = scope.getReference("maven.bin")) != null && ref.getValue() instanceof String) {
                this.setExe((String)ref.getValue());
            }
            if (this.getExe() == null) {
                if (SystemUtils.IS_WINDOWS) {
                    this.setExe("maven.bat");
                } else {
                    this.setExe("maven");
                }
            }
        }
    }

    public void execute(CommandContext context, CommandResult cmdResult) {
        this.checkExe();
        if (this.targets != null) {
            this.addArguments(this.targets.split(" +"));
            cmdResult.getProperties().put("targets", this.targets);
        }
        super.execute(context, cmdResult);
        MavenUtils.extractVersion(context, cmdResult, new File(this.getWorkingDir(context.getPaths()), "maven.xml"), "currentVersion");
        StoredArtifact artifact = cmdResult.getArtifact("command output");
        if (artifact != null) {
            MavenPostProcessor pp = new MavenPostProcessor("maven.pp");
            pp.process(artifact.getFile(), cmdResult, context);
        }
    }

    public String getTargets() {
        return this.targets;
    }

    public void setTargets(String targets) {
        this.targets = targets;
    }

    public void setScope(Scope scope) {
        super.setScope(scope);
        this.checkExe();
    }
}

