/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.core;

import com.zutubi.pulse.core.CommandContext;
import com.zutubi.pulse.core.ExecutableCommand;
import com.zutubi.pulse.core.Maven2PostProcessor;
import com.zutubi.pulse.core.MavenUtils;
import com.zutubi.pulse.core.Reference;
import com.zutubi.pulse.core.Scope;
import com.zutubi.pulse.core.model.CommandResult;
import com.zutubi.pulse.core.model.StoredArtifact;
import com.zutubi.pulse.util.SystemUtils;
import java.io.File;

public class Maven2Command
extends ExecutableCommand {
    private String goals;

    private void checkExe() {
        if (this.getExe() == null) {
            Reference ref;
            Scope scope = this.getScope();
            if (scope != null && (ref = scope.getReference("maven2.bin")) != null && ref.getValue() instanceof String) {
                this.setExe((String)ref.getValue());
            }
            if (this.getExe() == null) {
                if (SystemUtils.IS_WINDOWS) {
                    this.setExe("mvn.bat");
                } else {
                    this.setExe("mvn");
                }
            }
        }
    }

    public void execute(CommandContext context, CommandResult cmdResult) {
        this.checkExe();
        if (this.goals != null) {
            this.addArguments(this.goals.trim().split(" +"));
            cmdResult.getProperties().put("goals", this.goals);
        }
        super.execute(context, cmdResult);
        MavenUtils.extractVersion(context, cmdResult, new File(this.getWorkingDir(context.getPaths()), "pom.xml"), "version");
        StoredArtifact artifact = cmdResult.getArtifact("command output");
        if (artifact != null) {
            Maven2PostProcessor pp = new Maven2PostProcessor("maven.pp");
            pp.process(artifact.getFile(), cmdResult, context);
        }
    }

    public String getGoals() {
        return this.goals;
    }

    public void setGoals(String goals) {
        this.goals = goals;
    }

    public void setScope(Scope scope) {
        super.setScope(scope);
        this.checkExe();
    }
}

