/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.core;

import com.zutubi.pulse.core.CommandContext;
import com.zutubi.pulse.core.ExecutableCommand;
import com.zutubi.pulse.core.Reference;
import com.zutubi.pulse.core.Scope;
import com.zutubi.pulse.core.model.CommandResult;

public class MakeCommand
extends ExecutableCommand {
    private String makefile;
    private String targets;

    private void checkExe() {
        if (this.getExe() == null) {
            Reference ref;
            Scope scope = this.getScope();
            if (scope != null && (ref = scope.getReference("make.bin")) != null && ref.getValue() instanceof String) {
                this.setExe((String)ref.getValue());
            }
            if (this.getExe() == null) {
                this.setExe("make");
            }
        }
    }

    public void execute(CommandContext context, CommandResult cmdResult) {
        this.checkExe();
        if (this.makefile != null) {
            this.addArguments("-f", this.makefile);
            cmdResult.getProperties().put("makefile", this.makefile);
        }
        if (this.targets != null) {
            this.addArguments(this.targets.split(" +"));
            cmdResult.getProperties().put("targets", this.targets);
        }
        super.execute(context, cmdResult);
    }

    public String getMakefile() {
        return this.makefile;
    }

    public void setMakefile(String makefile) {
        this.makefile = makefile;
    }

    public String getTargets() {
        return this.targets;
    }

    public void setTargets(String targets) {
        this.targets = targets;
    }

    public void setScope(Scope scope) {
        super.setScope(scope);
        this.checkExe();
    }
}

