/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.core;

import com.zutubi.pulse.core.LocationAwareElement;
import nu.xom.Element;
import nu.xom.NodeFactory;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;

public class LocationAwareNodeFactory
extends NodeFactory {
    private Locator locator;
    private Location startLocation;
    private Location endLocation;

    public Element startMakingElement(String name, String namespace) {
        LocationAwareElement newElement = new LocationAwareElement(name, namespace);
        if (this.startLocation != null) {
            newElement.setLineNumber(this.startLocation.line);
            newElement.setColumnNumber(this.startLocation.column);
        }
        this.recordLocation();
        return newElement;
    }

    private void recordLocation() {
        if (this.locator != null) {
            this.startLocation = this.endLocation;
            this.endLocation = new Location(this.locator);
        }
    }

    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    public void startDocument() {
        this.recordLocation();
    }

    public void startElement(String string, String string1, String string2, Attributes attributes) {
        this.recordLocation();
    }

    public void endElement(String string, String string1, String string2) {
        this.recordLocation();
    }

    public void characters(char[] chars, int i, int i1) {
        this.recordLocation();
    }

    public void ignorableWhitespace(char[] chars, int i, int i1) {
        this.recordLocation();
    }

    public void processingInstruction(String string, String string1) {
        this.recordLocation();
    }

    private class Location {
        private int line;
        private int column;

        Location(Locator l) {
            this.line = l.getLineNumber();
            this.column = l.getColumnNumber();
        }

        public String toString() {
            return "[" + this.line + "," + this.column + "]";
        }
    }
}

