/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.core;

import com.zutubi.pulse.core.Artifact;
import com.zutubi.pulse.core.BuildException;
import com.zutubi.pulse.core.CommandContext;
import com.zutubi.pulse.core.ProcessArtifact;
import com.zutubi.pulse.core.model.CommandResult;
import com.zutubi.pulse.core.model.StoredArtifact;
import com.zutubi.pulse.core.model.StoredFileArtifact;
import com.zutubi.pulse.util.FileSystemUtils;
import com.zutubi.pulse.util.IOUtils;
import com.zutubi.validation.annotations.Name;
import com.zutubi.validation.annotations.Required;
import java.io.File;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;

public abstract class LocalArtifact
implements Artifact {
    private String name;
    private boolean failIfNotPresent = true;
    private boolean ignoreStale = false;
    private List<ProcessArtifact> processes = new LinkedList<ProcessArtifact>();

    public LocalArtifact(String name) {
        this.name = name;
    }

    public LocalArtifact() {
    }

    @Required
    @Name
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean getFailIfNotPresent() {
        return this.failIfNotPresent;
    }

    public void setFailIfNotPresent(boolean failIfNotPresent) {
        this.failIfNotPresent = failIfNotPresent;
    }

    public boolean getIgnoreStale() {
        return this.ignoreStale;
    }

    public void setIgnoreStale(boolean ignoreStale) {
        this.ignoreStale = ignoreStale;
    }

    public ProcessArtifact createProcess() {
        ProcessArtifact p = new ProcessArtifact();
        this.processes.add(p);
        return p;
    }

    protected boolean captureFile(StoredArtifact artifact, File fromFile, String path, CommandResult result, CommandContext context, String type) {
        if (this.ignoreStale && fromFile.lastModified() < context.getRecipeStartTime()) {
            return false;
        }
        File toFile = new File(context.getOutputDir(), path);
        File parent = toFile.getParentFile();
        try {
            FileSystemUtils.createDirectory(parent);
            IOUtils.copyFile(fromFile, toFile);
            StoredFileArtifact fileArtifact = new StoredFileArtifact(path, type);
            artifact.add(fileArtifact);
            for (ProcessArtifact process : this.processes) {
                process.getProcessor().process(fileArtifact, result, context);
            }
            return true;
        }
        catch (IOException e) {
            throw new BuildException("Unable to collect file '" + fromFile.getAbsolutePath() + "' for artifact '" + this.getName() + "': " + e.getMessage(), e);
        }
    }
}

