/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.core;

import com.zutubi.pulse.core.XMLReportPostProcessor;
import com.zutubi.pulse.core.model.TestCaseResult;
import com.zutubi.pulse.core.model.TestSuiteResult;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.Elements;
import nu.xom.Node;
import nu.xom.Text;

public class JUnitReportPostProcessor
extends XMLReportPostProcessor {
    private static final String ELEMENT_SUITE = "testsuite";
    private static final String ELEMENT_CASE = "testcase";
    private static final String ELEMENT_ERROR = "error";
    private static final String ELEMENT_FAILURE = "failure";
    private static final String ATTRIBUTE_CLASS = "classname";
    private static final String ATTRIBUTE_NAME = "name";
    private static final String ATTRIBUTE_PACKAGE = "package";
    private static final String ATTRIBUTE_TIME = "time";
    private String suiteElement = "testsuite";
    private String caseElement = "testcase";
    private String errorElement = "error";
    private String failureElement = "failure";
    private String classAttribute = "classname";
    private String nameAttribute = "name";
    private String packageAttribute = "package";
    private String timeAttribute = "time";

    public JUnitReportPostProcessor() {
        super("JUnit");
    }

    protected void processDocument(Document doc, TestSuiteResult tests) {
        Element root = doc.getRootElement();
        if (root.getLocalName().equals(this.suiteElement)) {
            this.processSuite(root, tests);
        } else {
            Elements suiteElements = root.getChildElements(this.suiteElement);
            for (int i = 0; i < suiteElements.size(); ++i) {
                this.processSuite(suiteElements.get(i), tests);
            }
        }
    }

    private void processSuite(Element element, TestSuiteResult tests) {
        String name = "";
        String attr = element.getAttributeValue(this.packageAttribute);
        if (attr != null) {
            name = name + attr + '.';
        }
        if ((attr = element.getAttributeValue(this.nameAttribute)) != null) {
            name = name + attr;
        }
        if (name.length() == 0) {
            return;
        }
        long duration = this.getDuration(element);
        TestSuiteResult suite = new TestSuiteResult(name, duration);
        Elements cases = element.getChildElements(this.caseElement);
        for (int i = 0; i < cases.size(); ++i) {
            this.processCase(cases.get(i), suite);
        }
        tests.add(suite);
    }

    private void processCase(Element element, TestSuiteResult suite) {
        String name = element.getAttributeValue(this.nameAttribute);
        if (name == null) {
            return;
        }
        String className = element.getAttributeValue(this.classAttribute);
        if (className != null && !suite.getName().equals(className)) {
            name = className + "." + name;
        }
        long duration = this.getDuration(element);
        TestCaseResult caseResult = new TestCaseResult(name, duration);
        suite.add(caseResult);
        Element child = element.getFirstChildElement(this.errorElement);
        if (child != null) {
            caseResult.setStatus(TestCaseResult.Status.ERROR);
            this.getMessage(child, caseResult);
            return;
        }
        child = element.getFirstChildElement(this.failureElement);
        if (child != null) {
            caseResult.setStatus(TestCaseResult.Status.FAILURE);
            this.getMessage(child, caseResult);
        }
    }

    private void getMessage(Element child, TestCaseResult caseResult) {
        Node node = child.getChild(0);
        if (node != null && node instanceof Text) {
            caseResult.setMessage(node.getValue().trim());
        }
    }

    private long getDuration(Element element) {
        long duration = -1L;
        String attr = element.getAttributeValue(this.timeAttribute);
        if (attr != null) {
            try {
                double time = Double.parseDouble(attr);
                duration = (long)(time * 1000.0);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        return duration;
    }

    public void setSuiteElement(String suiteElement) {
        this.suiteElement = suiteElement;
    }

    public void setCaseElement(String caseElement) {
        this.caseElement = caseElement;
    }

    public void setErrorElement(String errorElement) {
        this.errorElement = errorElement;
    }

    public void setFailureElement(String failureElement) {
        this.failureElement = failureElement;
    }

    public void setClassAttribute(String classAttribute) {
        this.classAttribute = classAttribute;
    }

    public void setNameAttribute(String nameAttribute) {
        this.nameAttribute = nameAttribute;
    }

    public void setPackageAttribute(String packageAttribute) {
        this.packageAttribute = packageAttribute;
    }

    public void setTimeAttribute(String timeAttribute) {
        this.timeAttribute = timeAttribute;
    }
}

