/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.core;

import com.zutubi.pulse.core.BuildException;
import com.zutubi.pulse.core.Command;
import com.zutubi.pulse.core.CommandContext;
import com.zutubi.pulse.core.ProcessArtifact;
import com.zutubi.pulse.core.ProcessSupport;
import com.zutubi.pulse.core.RecipePaths;
import com.zutubi.pulse.core.Reference;
import com.zutubi.pulse.core.Scope;
import com.zutubi.pulse.core.ScopeAware;
import com.zutubi.pulse.core.model.CommandResult;
import com.zutubi.pulse.core.model.StoredArtifact;
import com.zutubi.pulse.core.model.StoredFileArtifact;
import com.zutubi.pulse.util.Constants;
import com.zutubi.pulse.util.FileSystemUtils;
import com.zutubi.pulse.util.ForkOutputStream;
import com.zutubi.pulse.util.IOUtils;
import com.zutubi.pulse.util.SystemUtils;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExecutableCommand
implements Command,
ScopeAware {
    public static final String ENV_NAME = "environment";
    private static final String ENV_PATH = "PATH";
    private String name;
    private String exe;
    private List<Arg> args = new LinkedList<Arg>();
    private File workingDir;
    private List<Environment> env = new LinkedList<Environment>();
    private List<ProcessArtifact> processes = new LinkedList<ProcessArtifact>();
    private Scope scope;
    private Process child;
    private CancellableReader reader;
    private volatile boolean terminated = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(CommandContext context, CommandResult cmdResult) {
        File workingDir = this.getWorkingDir(context.getPaths());
        ProcessBuilder builder = new ProcessBuilder(this.constructCommand(workingDir));
        builder.directory(workingDir);
        this.updateChildEnvironment(builder, context);
        builder.redirectErrorStream(true);
        File envFileDir = new File(context.getOutputDir(), ENV_NAME);
        if (!envFileDir.mkdir()) {
            throw new BuildException("Unable to create directory for the environment artifact '" + envFileDir.getAbsolutePath() + "'");
        }
        try {
            this.recordExecutionEnvironment(builder, cmdResult, envFileDir);
        }
        catch (IOException e) {
            throw new BuildException("Unable to record the process execution environment. ", e);
        }
        File outputFileDir = new File(context.getOutputDir(), "command output");
        if (!outputFileDir.mkdir()) {
            throw new BuildException("Unable to create directory for the output artifact '" + outputFileDir.getAbsolutePath() + "'");
        }
        if (this.terminatedCheck(cmdResult)) {
            return;
        }
        try {
            this.child = builder.start();
        }
        catch (IOException e) {
            String message = e.getMessage();
            if (message.contains("nosuchexe") || message.endsWith("error=2")) {
                message = "No such executable '" + this.exe + "'";
            } else if (message.endsWith("error=267")) {
                message = "Working directory '" + this.workingDir.getPath() + "' does not exist";
            }
            throw new BuildException("Unable to create process: " + message, e);
        }
        File outputFile = new File(outputFileDir, "output.txt");
        try {
            FileOutputStream outputFileStream = new FileOutputStream(outputFile);
            OutputStream output = context.getOutputStream() != null ? new ForkOutputStream(outputFileStream, context.getOutputStream()) : outputFileStream;
            InputStream input = this.child.getInputStream();
            this.reader = new CancellableReader(input, output);
            this.reader.start();
            if (this.terminatedCheck(cmdResult)) {
                return;
            }
            int result = this.child.waitFor();
            boolean readerComplete = this.reader.waitFor(10L);
            while (!this.terminated && !readerComplete) {
                this.reader.waitFor(10L);
            }
            if (readerComplete) {
                IOException ioe = this.reader.getIoError();
                if (ioe != null) {
                    throw new BuildException(ioe);
                }
            } else {
                cmdResult.error("Unable to cleanly terminate the child process tree.  It is likely that some orphaned processes remain.");
            }
            String commandLine = this.constructCommandLine(builder);
            if (result == 0) {
                cmdResult.success();
            } else {
                cmdResult.failure("Command '" + commandLine + "' exited with code '" + result + "'");
            }
            cmdResult.getProperties().put("exit code", Integer.toString(result));
            cmdResult.getProperties().put("command line", commandLine);
            if (builder.directory() != null) {
                cmdResult.getProperties().put("working directory", builder.directory().getAbsolutePath());
            }
        }
        catch (IOException e) {
            throw new BuildException(e);
        }
        catch (InterruptedException e) {
            if (!this.terminatedCheck(cmdResult)) {
                throw new BuildException(e);
            }
        }
        finally {
            if (outputFile.exists()) {
                ProcessSupport.postProcess(this.processes, outputFileDir, outputFile, cmdResult, context);
            }
        }
    }

    private boolean terminatedCheck(CommandResult commandResult) {
        if (this.terminated) {
            commandResult.error("Command terminated");
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recordExecutionEnvironment(ProcessBuilder builder, CommandResult cmdResult, File outputDir) throws IOException {
        File file = new File(outputDir, "env.txt");
        String separator = Constants.LINE_SEPARATOR;
        StringBuffer buffer = new StringBuffer();
        buffer.append("Command Line:").append(separator);
        buffer.append("-------------").append(separator);
        buffer.append(this.constructCommandLine(builder)).append(separator);
        buffer.append(separator);
        buffer.append("Process Environment:").append(separator);
        buffer.append("--------------------").append(separator);
        TreeMap<String, String> env = new TreeMap<String, String>(builder.environment());
        for (String string : env.keySet()) {
            buffer.append(string).append("=").append((String)env.get(string)).append(separator);
        }
        buffer.append(separator);
        buffer.append("Resources: (via scope)").append(separator);
        buffer.append("----------------------").append(separator);
        if (this.scope != null && this.scope.getEnvironment().size() > 0) {
            for (Map.Entry entry : this.scope.getEnvironment().entrySet()) {
                buffer.append((String)entry.getKey()).append("=").append((String)entry.getValue()).append(separator);
            }
        } else {
            buffer.append("No environment variables defined via the command scope.").append(separator);
        }
        buffer.append(separator);
        buffer.append("Resources: (via environment tag)").append(separator);
        buffer.append("--------------------------------").append(separator);
        if (this.env.size() > 0) {
            for (Environment environment : this.env) {
                buffer.append(environment.getName()).append("=").append(environment.getValue()).append(separator);
            }
        } else {
            buffer.append("No environment variables defined via the command env tags.").append(separator);
        }
        BufferedWriter writer = null;
        try {
            writer = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(file)));
            writer.append(buffer.toString());
            ((Writer)writer).flush();
        }
        catch (Throwable throwable) {
            IOUtils.close(writer);
            throw throwable;
        }
        IOUtils.close(writer);
        String string = FileSystemUtils.composeFilename(outputDir.getName(), file.getName());
        StoredArtifact envArtifact = new StoredArtifact(ENV_NAME, new StoredFileArtifact(string, "text/plain"));
        cmdResult.addArtifact(envArtifact);
    }

    protected StoredFileArtifact getOutputFileArtifact(CommandResult result) {
        StoredArtifact outputArtifact = result.getArtifact("command output");
        for (StoredFileArtifact file : outputArtifact.getChildren()) {
            if (!file.getPath().equals("command output/output.txt")) continue;
            return file;
        }
        return null;
    }

    private List<String> constructCommand(File workingDir) {
        String binary = this.exe;
        File exeFile = new File(this.exe);
        if (!exeFile.isAbsolute()) {
            File relativeToWork = new File(workingDir, this.exe);
            if (relativeToWork.exists()) {
                binary = relativeToWork.getAbsolutePath();
            } else {
                exeFile = SystemUtils.findInPath(this.exe, this.scope == null ? null : this.scope.getPathDirectories());
                if (exeFile != null) {
                    binary = exeFile.getAbsolutePath();
                }
            }
        }
        LinkedList<String> command = new LinkedList<String>();
        command.add(binary);
        if (this.args != null) {
            for (Arg arg : this.args) {
                command.add(arg.getText());
            }
        }
        return command;
    }

    protected File getWorkingDir(RecipePaths paths) {
        if (this.workingDir == null) {
            return paths.getBaseDir();
        }
        if (this.workingDir.isAbsolute()) {
            return this.workingDir;
        }
        return new File(paths.getBaseDir(), this.workingDir.getPath());
    }

    /*
     * WARNING - void declaration
     */
    private void updateChildEnvironment(ProcessBuilder builder, CommandContext context) {
        Map<String, String> childEnvironment = builder.environment();
        if (this.scope != null) {
            void var5_8;
            for (Map.Entry entry : this.scope.getEnvironment().entrySet()) {
                childEnvironment.put((String)entry.getKey(), (String)entry.getValue());
            }
            String pathKey = ENV_PATH;
            String string = this.scope.getPathPrefix();
            String translatedKey = this.translateKey(ENV_PATH, childEnvironment);
            if (translatedKey != null) {
                String path = childEnvironment.get(translatedKey);
                pathKey = translatedKey;
                String string2 = string + path;
            }
            childEnvironment.put(pathKey, (String)var5_8);
        }
        for (Environment environment : this.env) {
            childEnvironment.put(environment.getName(), environment.getValue());
        }
        Scope globalScope = context.getGlobalScope();
        if (globalScope != null) {
            for (Reference reference : globalScope.getReferences()) {
                if (!this.acceptableName(reference.getName()) || !(reference.getValue() instanceof String)) continue;
                String value = (String)reference.getValue();
                childEnvironment.put(this.convertName(reference.getName()), value);
            }
        }
    }

    private boolean acceptableName(String name) {
        if (name.startsWith("env.")) {
            return false;
        }
        return name.matches("[-a-zA-Z._]+");
    }

    private String convertName(String name) {
        name = name.toUpperCase();
        name = name.replaceAll("\\.", "_");
        return "PULSE_" + name;
    }

    private String translateKey(String propertyName, Map<String, String> map) {
        propertyName = propertyName.toLowerCase();
        for (String key : map.keySet()) {
            if (!key.toLowerCase().equals(propertyName)) continue;
            return key;
        }
        return null;
    }

    protected Scope getScope() {
        return this.scope;
    }

    @Override
    public List<String> getArtifactNames() {
        return Arrays.asList("command output");
    }

    public String getExe() {
        return this.exe;
    }

    public void setExe(String exe) {
        this.exe = exe;
    }

    public void setArgs(String args) {
        for (String arg : args.split(" ")) {
            Arg a = this.createArg();
            a.setText(arg);
        }
    }

    public void setWorkingDir(File d) {
        this.workingDir = d;
    }

    public Arg createArg() {
        Arg arg = new Arg();
        this.args.add(arg);
        return arg;
    }

    protected void addArguments(String ... arguments) {
        for (String arg : arguments) {
            Arg argument = new Arg(arg);
            this.args.add(argument);
        }
    }

    public Environment createEnvironment() {
        Environment setting = new Environment();
        this.env.add(setting);
        return setting;
    }

    public ProcessArtifact createProcess() {
        ProcessArtifact p = new ProcessArtifact();
        this.processes.add(p);
        return p;
    }

    private String constructCommandLine(ProcessBuilder builder) {
        StringBuffer result = new StringBuffer();
        boolean first = true;
        for (String part : builder.command()) {
            boolean containsSpaces;
            if (first) {
                first = false;
            } else {
                result.append(' ');
            }
            boolean bl = containsSpaces = part.indexOf(32) != -1;
            if (containsSpaces) {
                result.append('\"');
            }
            result.append(part);
            if (!containsSpaces) continue;
            result.append('\"');
        }
        return result.toString();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public void terminate() {
        this.terminated = true;
        if (this.child != null) {
            this.child.destroy();
        }
        if (this.reader != null) {
            this.reader.cancel();
        }
    }

    List<Arg> getArgs() {
        return this.args;
    }

    @Override
    public void setScope(Scope scope) {
        this.scope = scope;
    }

    class CancellableReader {
        private Thread readerThread;
        private InputStream in;
        private OutputStream out;
        private IOException ioError = null;
        private boolean interrupted = false;

        public CancellableReader(InputStream in, OutputStream out) {
            this.in = in;
            this.out = out;
        }

        public synchronized void start() {
            this.readerThread = new Thread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    try {
                        int n;
                        byte[] buffer = new byte[1024];
                        while (!CancellableReader.this.interrupted && !Thread.interrupted() && (n = CancellableReader.this.in.read(buffer)) > 0) {
                            CancellableReader.this.out.write(buffer, 0, n);
                        }
                    }
                    catch (IOException e) {
                        CancellableReader.this.ioError = e;
                    }
                    finally {
                        CancellableReader.this.close();
                    }
                }
            });
            this.readerThread.start();
        }

        private void close() {
            IOUtils.close(this.in);
            IOUtils.close(this.out);
        }

        public synchronized void cancel() {
            this.interrupted = true;
        }

        public boolean waitFor(long seconds) {
            try {
                this.readerThread.join(1000L * seconds);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return !this.readerThread.isAlive();
        }

        public IOException getIoError() {
            return this.ioError;
        }
    }

    public class Environment {
        private String name;
        private String value;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }
    }

    public class Arg {
        private String text;

        public Arg() {
            this.text = "";
        }

        public Arg(String text) {
            this.text = text;
        }

        public String getText() {
            return this.text;
        }

        public void setText(String text) {
            this.text = this.text + text;
        }
    }
}

