/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.core;

import com.zutubi.pulse.core.XMLReportPostProcessor;
import com.zutubi.pulse.core.model.TestCaseResult;
import com.zutubi.pulse.core.model.TestSuiteResult;
import java.util.Map;
import java.util.TreeMap;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.Elements;

public class CppUnitReportPostProcessor
extends XMLReportPostProcessor {
    private static final String ELEMENT_SUCCESSFUL_TESTS = "SuccessfulTests";
    private static final String ELEMENT_TEST = "Test";
    private static final String ELEMENT_FAILED_TESTS = "FailedTests";
    private static final String ELEMENT_FAILED_TEST = "FailedTest";
    private static final String ELEMENT_NAME = "Name";
    private static final String ELEMENT_FAILURE_TYPE = "FailureType";
    private static final String ELEMENT_LOCATION = "Location";
    private static final String ELEMENT_FILE = "File";
    private static final String ELEMENT_LINE = "Line";
    private static final String ELEMENT_MESSAGE = "Message";
    private static final String FAILURE_TYPE_ERROR = "Error";
    private static final String FAILURE_TYPE_ASSERTION = "Assertion";
    private Map<String, TestSuiteResult> suites;

    public CppUnitReportPostProcessor() {
        super("CppUnit");
    }

    protected void processDocument(Document doc, TestSuiteResult tests) {
        int i;
        Element root = doc.getRootElement();
        this.suites = new TreeMap<String, TestSuiteResult>();
        Elements testElements = root.getChildElements(ELEMENT_FAILED_TESTS);
        for (i = 0; i < testElements.size(); ++i) {
            this.processFailedTests(testElements.get(i));
        }
        testElements = root.getChildElements(ELEMENT_SUCCESSFUL_TESTS);
        for (i = 0; i < testElements.size(); ++i) {
            this.processSuccessfulTests(testElements.get(i));
        }
        this.addSuites(tests);
    }

    private void processFailedTests(Element element) {
        Elements elements = element.getChildElements(ELEMENT_FAILED_TEST);
        for (int i = 0; i < elements.size(); ++i) {
            Element testElement = elements.get(i);
            String[] name = this.getTestName(testElement);
            TestCaseResult.Status status = this.getStatus(testElement);
            String message = this.getMessage(testElement);
            TestSuiteResult suite = this.getSuite(name[0]);
            TestCaseResult result = new TestCaseResult(name[1], -1L, status, message);
            suite.add(result);
        }
    }

    private void processSuccessfulTests(Element element) {
        Elements elements = element.getChildElements(ELEMENT_TEST);
        for (int i = 0; i < elements.size(); ++i) {
            Element testElement = elements.get(i);
            String[] name = this.getTestName(testElement);
            TestSuiteResult suite = this.getSuite(name[0]);
            TestCaseResult result = new TestCaseResult(name[1]);
            suite.add(result);
        }
    }

    private void addSuites(TestSuiteResult tests) {
        for (TestSuiteResult suite : this.suites.values()) {
            tests.add(suite);
        }
    }

    private TestSuiteResult getSuite(String name) {
        if (this.suites.containsKey(name)) {
            return this.suites.get(name);
        }
        TestSuiteResult suite = new TestSuiteResult(name);
        this.suites.put(name, suite);
        return suite;
    }

    private String[] getTestName(Element testElement) {
        Element nameElement = testElement.getFirstChildElement(ELEMENT_NAME);
        if (nameElement == null) {
            return null;
        }
        String name = this.getText(nameElement);
        if (name == null) {
            return null;
        }
        String[] bits = name.split("::", 2);
        if (bits.length == 1) {
            return new String[]{"[unknown]", bits[0]};
        }
        return bits;
    }

    private TestCaseResult.Status getStatus(Element element) {
        String type;
        TestCaseResult.Status status = TestCaseResult.Status.FAILURE;
        Element typeElement = element.getFirstChildElement(ELEMENT_FAILURE_TYPE);
        if (typeElement != null && (type = this.getText(typeElement)) != null && type.equals(FAILURE_TYPE_ERROR)) {
            status = TestCaseResult.Status.ERROR;
        }
        return status;
    }

    private String getMessage(Element element) {
        String text;
        Element messageElement;
        String message = "";
        Element locationElement = element.getFirstChildElement(ELEMENT_LOCATION);
        if (locationElement != null) {
            String line;
            Element lineElement;
            String file;
            String location = "At";
            Element fileElement = locationElement.getFirstChildElement(ELEMENT_FILE);
            if (fileElement != null && (file = this.getText(fileElement)) != null) {
                location = location + " file " + file;
            }
            if ((lineElement = locationElement.getFirstChildElement(ELEMENT_LINE)) != null && (line = this.getText(lineElement)) != null) {
                location = location + " line " + line;
            }
            message = message + location + "\n";
        }
        if ((messageElement = element.getFirstChildElement(ELEMENT_MESSAGE)) != null && (text = this.getText(messageElement)) != null) {
            message = message + text;
        }
        return message;
    }
}

