/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.core;

import com.zutubi.pulse.core.Bootstrapper;
import com.zutubi.pulse.core.Command;
import com.zutubi.pulse.core.CommandContext;
import com.zutubi.pulse.core.model.CommandResult;
import com.zutubi.pulse.core.model.StoredArtifact;
import com.zutubi.pulse.core.model.StoredFileArtifact;
import com.zutubi.pulse.util.FileSystemUtils;
import java.io.File;
import java.util.Arrays;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BootstrapCommand
implements Command {
    public static final String OUTPUT_NAME = "bootstrap output";
    public static final String FILES_FILE = "files.txt";
    private Bootstrapper bootstrapper;

    public BootstrapCommand(Bootstrapper bootstrapper) {
        this.bootstrapper = bootstrapper;
    }

    @Override
    public void execute(CommandContext context, CommandResult result) {
        String[] files;
        this.bootstrapper.bootstrap(context);
        File artifactDir = new File(context.getOutputDir(), OUTPUT_NAME);
        if (artifactDir.isDirectory() && (files = artifactDir.list()).length > 0) {
            StoredArtifact artifact = new StoredArtifact(OUTPUT_NAME);
            for (String file : files) {
                artifact.add(new StoredFileArtifact(FileSystemUtils.composeFilename(OUTPUT_NAME, file)));
            }
            result.addArtifact(artifact);
        }
    }

    @Override
    public List<String> getArtifactNames() {
        return Arrays.asList(OUTPUT_NAME);
    }

    @Override
    public String getName() {
        return "bootstrap";
    }

    @Override
    public void setName(String name) {
    }

    @Override
    public void terminate() {
        this.bootstrapper.terminate();
    }
}

