/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.config;

import com.zutubi.pulse.config.Config;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;

public class CompositeConfig
implements Config {
    private List<Config> delegates;

    public CompositeConfig(Config ... configs) {
        this.delegates = configs == null ? new ArrayList<Config>() : new LinkedList<Config>(Arrays.asList(configs));
    }

    public void append(Config config) {
        this.delegates.add(config);
    }

    public void prepend(Config config) {
        this.delegates.add(0, config);
    }

    public String getProperty(String key) {
        for (Config config : this.delegates) {
            if (!config.hasProperty(key)) continue;
            return config.getProperty(key);
        }
        return null;
    }

    public void setProperty(String key, String value) {
        for (Config config : this.delegates) {
            if (!config.isWriteable()) {
                return;
            }
            config.setProperty(key, value);
        }
    }

    public boolean hasProperty(String key) {
        for (Config config : this.delegates) {
            if (!config.hasProperty(key)) continue;
            return true;
        }
        return false;
    }

    public void removeProperty(String key) {
        for (Config config : this.delegates) {
            if (!config.isWriteable()) {
                return;
            }
            if (!config.hasProperty(key)) continue;
            config.removeProperty(key);
        }
    }

    public boolean isWriteable() {
        if (this.delegates.size() > 0) {
            return this.delegates.get(0).isWriteable();
        }
        return false;
    }
}

