/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.command;

import com.zutubi.pulse.command.BootContext;
import com.zutubi.pulse.command.Command;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HelpCommand
implements Command {
    public int execute(BootContext context) throws Exception {
        String[] argv = context.getArgv();
        if (argv.length <= 1) {
            this.showHelp(context.getCommands());
        } else {
            HashMap<String, Command> aliasCommands = new HashMap<String, Command>(context.getCommands());
            for (Command command : context.getCommands().values()) {
                List aliases = command.getAliases();
                if (aliases == null) continue;
                for (String alias : aliases) {
                    aliasCommands.put(alias, command);
                }
            }
            Command command = (Command)aliasCommands.get(argv[1]);
            if (command == null || command.getHelp() == null) {
                System.err.println("Unrecognised command '" + argv[1] + "'");
                return 1;
            }
            this.showHelp(argv[1], command);
        }
        return 0;
    }

    public String getHelp() {
        return "show command documentation";
    }

    public String getDetailedHelp() {
        return "Displays usage and parameter information for available commands.";
    }

    public List<String> getUsages() {
        return Arrays.asList("[ <command> ]");
    }

    public List<String> getAliases() {
        return null;
    }

    public Map<String, String> getOptions() {
        return null;
    }

    public boolean isDefault() {
        return true;
    }

    private void showHelp(Map<String, Command> commands) {
        System.out.println("Usage: pulse <command> [ <option> ... ] [ <arg> ... ]");
        System.out.println();
        System.out.println("Available commands:");
        for (Map.Entry<String, Command> entry : commands.entrySet()) {
            Command command = entry.getValue();
            if (command.getHelp() == null) continue;
            System.out.println(String.format("  %-16s: %s", entry.getKey(), entry.getValue().getHelp()));
        }
        System.out.println();
        System.out.println("For help on a specific command, type 'pulse help <command>'");
    }

    public void showHelp(String name, Command command) {
        System.out.println(name + ": " + command.getHelp());
        List aliases = command.getAliases();
        if (aliases != null) {
            System.out.println("Aliases: " + aliases.toString());
        }
        String usageString = "Usage:";
        for (String usage : command.getUsages()) {
            System.out.println(String.format("%s %s %s", usageString, name, usage));
            usageString = "      ";
        }
        System.out.println();
        System.out.println(command.getDetailedHelp());
        Map options = command.getOptions();
        if (options != null) {
            System.out.println();
            System.out.println("Available options:");
            for (Map.Entry option : options.entrySet()) {
                System.out.println(String.format("%-26s: %s", option.getKey(), option.getValue()));
            }
        }
        System.out.println();
    }
}

