/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.plugins.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class FileUtils {
    private static final int DEFAULT_BUFFER_SIZE = 4096;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(File source, File destination) throws IOException {
        if (!source.exists()) {
            String message = "File " + source + " does not exist";
            throw new IOException(message);
        }
        if (destination.getParentFile() != null && !destination.getParentFile().exists()) {
            destination.getParentFile().mkdirs();
        }
        if (destination.exists() && !destination.canWrite()) {
            String message = "Unable to open file " + destination + " for writing.";
            throw new IOException(message);
        }
        FileInputStream input = null;
        FileOutputStream output = null;
        try {
            input = new FileInputStream(source);
            output = new FileOutputStream(destination);
            FileUtils.copy(input, output);
        }
        catch (Throwable throwable) {
            FileUtils.close(input);
            FileUtils.close(output);
            throw throwable;
        }
        FileUtils.close(input);
        FileUtils.close(output);
        if (source.length() != destination.length()) {
            String message = "Failed to copy full contents from " + source + " to " + destination;
            throw new IOException(message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int copyAndClose(InputStream input, OutputStream output) throws IOException {
        try {
            int n = FileUtils.copy(input, output);
            return n;
        }
        finally {
            FileUtils.close(input);
            FileUtils.close(output);
        }
    }

    public static int copy(InputStream input, OutputStream output) throws IOException {
        return FileUtils.copy(input, output, 4096);
    }

    public static int copy(InputStream input, OutputStream output, int bufferSize) throws IOException {
        int n;
        byte[] buffer = new byte[bufferSize];
        int count = 0;
        while (-1 != (n = input.read(buffer))) {
            output.write(buffer, 0, n);
            count += n;
        }
        return count;
    }

    public static void close(OutputStream output) {
        if (output == null) {
            return;
        }
        try {
            output.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void close(InputStream input) {
        if (input == null) {
            return;
        }
        try {
            input.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void copyDirectory(File srcDir, File destDir) throws IOException {
        if (!srcDir.exists()) {
            throw new IllegalArgumentException("Source dir [" + srcDir + "] does not exist");
        }
        FileUtils.copyDirectory(srcDir, destDir, false);
    }

    public static void copyDirectory(File srcDir, File destDir, boolean overwrite) throws IOException {
        File[] files = srcDir.listFiles();
        if (!destDir.exists()) {
            destDir.mkdirs();
        }
        if (files != null) {
            for (File file : files) {
                File dest = new File(destDir, file.getName());
                if (file.isFile()) {
                    FileUtils.copyFile(file, dest);
                    continue;
                }
                FileUtils.copyDirectory(file, dest, overwrite);
            }
        }
    }

    public static boolean deleteDir(File dir) {
        if (dir == null) {
            return false;
        }
        File[] files = dir.listFiles();
        if (files != null) {
            for (File file : files) {
                boolean noDeleted;
                boolean bl = noDeleted = !file.delete();
                if (!noDeleted || !file.isDirectory()) continue;
                FileUtils.deleteDir(file);
            }
        }
        return dir.delete();
    }

    public static String randomString(int length) {
        StringBuffer b = new StringBuffer(length);
        for (int i = 0; i < length; ++i) {
            b.append(FileUtils.randomAlpha());
        }
        return b.toString();
    }

    public static char randomAlpha() {
        int i = (int)(Math.random() * 52.0);
        if (i > 25) {
            return (char)(97 + i - 26);
        }
        return (char)(65 + i);
    }
}

