/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.plugins.internal.loaders;

import com.zutubi.plugins.ComponentDescriptorFactory;
import com.zutubi.plugins.Plugin;
import com.zutubi.plugins.PluginLoader;
import com.zutubi.plugins.internal.DefaultPlugin;
import com.zutubi.plugins.internal.XMLPluginDescriptorSupport;
import com.zutubi.plugins.utils.IOUtils;
import java.io.InputStream;
import java.net.URL;
import java.util.Collection;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PluginLoaderSupport
implements PluginLoader {
    private XMLPluginDescriptorSupport xmlDescriptorSupport = new XMLPluginDescriptorSupport();
    protected String resource = "plugin.xml";

    public void setComponentDescriptorFactory(ComponentDescriptorFactory descriptorFactory) {
        this.xmlDescriptorSupport.setDescriptorFactory(descriptorFactory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Plugin loadPlugin(URL descriptor, ClassLoader loader, URL source) {
        InputStream input = null;
        try {
            input = descriptor.openStream();
            DefaultPlugin plugin = new DefaultPlugin();
            plugin.setLoader(loader);
            plugin.setSource(source);
            DefaultPlugin defaultPlugin = this.xmlDescriptorSupport.loadPlugin(input, plugin);
            return defaultPlugin;
        }
        catch (Exception e) {
            e.printStackTrace();
            Plugin plugin = null;
            return plugin;
        }
        finally {
            IOUtils.close(input);
        }
    }

    protected List<Plugin> loadPlugins(Enumeration<URL> pluginDefs, ClassLoader classLoader, URL source) {
        LinkedList<Plugin> plugins = new LinkedList<Plugin>();
        for (URL pluginDefinition : this.toCollection(pluginDefs)) {
            Plugin plugin = this.loadPlugin(pluginDefinition, classLoader, source);
            if (plugin == null) continue;
            plugins.add(plugin);
        }
        return plugins;
    }

    private <T> Collection<T> toCollection(Enumeration<T> enumeration) {
        LinkedList<T> c = new LinkedList<T>();
        while (enumeration.hasMoreElements()) {
            c.add(enumeration.nextElement());
        }
        return c;
    }

    public void setDescriptor(String resource) {
        this.resource = resource;
    }
}

