/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.plugins.internal.loaders;

import com.zutubi.plugins.Plugin;
import com.zutubi.plugins.classloader.DirectoryClassLoader;
import com.zutubi.plugins.internal.loaders.PluginLoaderSupport;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DirectoryPluginLoader
extends PluginLoaderSupport {
    private File base = null;

    public DirectoryPluginLoader() {
    }

    public DirectoryPluginLoader(File base) {
        this.setBaseDirectory(base);
    }

    public void setBaseDirectory(File base) {
        if (base == null) {
            throw new IllegalArgumentException();
        }
        if (!base.isDirectory()) {
            throw new IllegalArgumentException();
        }
        this.base = base;
    }

    @Override
    public List<Plugin> loadPlugins() {
        ClassLoader parent = Thread.currentThread().getContextClassLoader();
        if (parent == null) {
            parent = this.getClass().getClassLoader();
        }
        try {
            DirectoryClassLoader loader = new DirectoryClassLoader(this.base, parent);
            URL pluginDescriptor = loader.findResource(this.resource);
            Plugin plugin = this.loadPlugin(pluginDescriptor, loader, this.base.toURI().toURL());
            LinkedList<Plugin> plugins = new LinkedList<Plugin>();
            if (plugin != null) {
                plugins.add(plugin);
            }
            return plugins;
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            return new LinkedList<Plugin>();
        }
    }
}

