/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.plugins.internal.loaders;

import com.zutubi.plugins.Plugin;
import com.zutubi.plugins.classloader.JarClassLoader;
import com.zutubi.plugins.internal.loaders.PluginLoaderSupport;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArchivePluginLoader
extends PluginLoaderSupport {
    private static final Logger LOG = Logger.getLogger(ArchivePluginLoader.class.getName());
    private File archiveFile = null;

    public ArchivePluginLoader() {
    }

    public ArchivePluginLoader(File pluginFile) {
        this.setArchive(pluginFile);
    }

    public void setArchive(File file) {
        if (file == null) {
            throw new IllegalArgumentException();
        }
        if (!file.isFile()) {
            throw new IllegalArgumentException();
        }
        this.archiveFile = file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Plugin> loadPlugins() {
        ClassLoader parent = Thread.currentThread().getContextClassLoader();
        if (parent == null) {
            parent = this.getClass().getClassLoader();
        }
        JarClassLoader loader = null;
        try {
            loader = new JarClassLoader(this.archiveFile, parent);
            URL descriptor = loader.findResource(this.resource);
            if (descriptor == null) {
                return new LinkedList<Plugin>();
            }
            Plugin plugin = this.loadPlugin(descriptor, loader, this.archiveFile.toURI().toURL());
            if (plugin == null) {
                return new LinkedList<Plugin>();
            }
            return Arrays.asList(plugin);
        }
        catch (IOException ioe) {
            try {
                LOG.log(Level.WARNING, ioe.getMessage(), ioe);
                LinkedList<Plugin> linkedList = new LinkedList<Plugin>();
                return linkedList;
            }
            finally {
                loader.close();
            }
        }
    }
}

