/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.plugins.internal;

import com.zutubi.plugins.ComponentDescriptor;
import com.zutubi.plugins.ComponentDescriptorFactory;
import com.zutubi.plugins.PluginException;
import com.zutubi.plugins.PluginInformation;
import com.zutubi.plugins.PluginParseException;
import com.zutubi.plugins.internal.DefaultPlugin;
import java.io.IOException;
import java.io.InputStream;
import nu.xom.Builder;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.Elements;
import nu.xom.ParsingException;

public class XMLPluginDescriptorSupport {
    private ComponentDescriptorFactory descriptorFactory;

    public void setDescriptorFactory(ComponentDescriptorFactory descriptorFactory) {
        this.descriptorFactory = descriptorFactory;
    }

    public DefaultPlugin loadPlugin(InputStream pluginXml, DefaultPlugin plugin) throws PluginException, IOException {
        Document doc = this.createDocument(pluginXml);
        Element root = doc.getRootElement();
        this.readPlugin(root, plugin);
        Element info = root.getFirstChildElement("plugin-info");
        if (info != null) {
            this.readPluginInfo(info, plugin);
        }
        this.readComponentDescriptors(root, plugin);
        return plugin;
    }

    private void readPlugin(Element root, DefaultPlugin plugin) {
        plugin.setName(root.getAttributeValue("name"));
        plugin.setKey(root.getAttributeValue("key"));
    }

    private void readComponentDescriptors(Element root, DefaultPlugin plugin) {
        Elements children = root.getChildElements();
        for (int i = 0; i < children.size(); ++i) {
            Element child = children.get(i);
            String name = child.getLocalName();
            if (!this.descriptorFactory.supportsComponentDescriptor(name)) continue;
            ComponentDescriptor descriptorInstance = this.descriptorFactory.createComponentDescriptor(name, child, plugin);
            descriptorInstance.setPlugin(plugin);
            plugin.addComponentDescriptor(descriptorInstance);
        }
    }

    private void readPluginInfo(Element info, DefaultPlugin plugin) {
        Element infoVendor;
        Element infoAppVersion;
        Element infoVersion;
        PluginInformation pluginInfo = new PluginInformation();
        Element infoDesc = info.getFirstChildElement("description");
        if (infoDesc != null) {
            pluginInfo.setDescription(infoDesc.getValue());
        }
        if ((infoVersion = info.getFirstChildElement("version")) != null) {
            pluginInfo.setPluginVersion(infoVersion.getValue());
        }
        if ((infoAppVersion = info.getFirstChildElement("application-version")) != null) {
            pluginInfo.setMinSupportedAppVersion(infoAppVersion.getAttributeValue("min"));
            pluginInfo.setMaxSupportedAppVersion(infoAppVersion.getAttributeValue("max"));
        }
        if ((infoVendor = info.getFirstChildElement("vendor")) != null) {
            pluginInfo.setVendorName(infoVendor.getAttributeValue("name"));
            pluginInfo.setVendorURL(infoVendor.getAttributeValue("url"));
        }
        plugin.setInfo(pluginInfo);
    }

    private Document createDocument(InputStream pluginXml) throws PluginException, IOException {
        Document doc;
        Builder builder = new Builder();
        try {
            doc = builder.build(pluginXml);
        }
        catch (ParsingException pex) {
            throw new PluginParseException(pex);
        }
        return doc;
    }
}

