/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.plugins.internal;

import com.zutubi.plugins.ComponentDescriptor;
import com.zutubi.plugins.Plugin;
import com.zutubi.plugins.PluginInformation;
import com.zutubi.plugins.classloader.PluginsClassLoader;
import com.zutubi.plugins.utils.ClassLoaderUtils;
import java.io.InputStream;
import java.net.URL;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultPlugin
implements Plugin {
    private String key;
    private String name;
    private PluginInformation info;
    private List<ComponentDescriptor> componentDescriptors = new LinkedList<ComponentDescriptor>();
    private boolean enabled;
    private boolean hidden;
    private URL source;
    protected ClassLoader loader;

    public void setLoader(ClassLoader loader) {
        this.loader = loader;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    protected void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public void enable() {
        if (!this.isEnabled()) {
            for (ComponentDescriptor descriptor : this.componentDescriptors) {
                if (descriptor.isEnabled()) continue;
                descriptor.enable();
            }
            this.enabled = true;
        }
    }

    @Override
    public void disable() {
        if (this.isEnabled()) {
            for (ComponentDescriptor descriptor : this.componentDescriptors) {
                if (!descriptor.isEnabled()) continue;
                descriptor.disable();
            }
            this.enabled = false;
        }
    }

    @Override
    public boolean isHidden() {
        return this.hidden;
    }

    protected void setHidden(boolean hidden) {
        this.hidden = hidden;
    }

    @Override
    public PluginInformation getInfo() {
        return this.info;
    }

    protected void setInfo(PluginInformation info) {
        this.info = info;
    }

    @Override
    public String getName() {
        return this.name;
    }

    protected void setName(String name) {
        this.name = name;
    }

    @Override
    public String getKey() {
        return this.key;
    }

    protected void setKey(String key) {
        this.key = key;
    }

    @Override
    public List<ComponentDescriptor> getComponentDescriptors() {
        return this.componentDescriptors;
    }

    protected void setComponentDescriptors(List<ComponentDescriptor> componentDescriptors) {
        this.componentDescriptors = componentDescriptors;
    }

    protected void addComponentDescriptor(ComponentDescriptor descriptor) {
        this.componentDescriptors.add(descriptor);
    }

    @Override
    public URL getSource() {
        return this.source;
    }

    public void setSource(URL source) {
        this.source = source;
    }

    @Override
    public Class loadClass(String className, Class callingClass) throws ClassNotFoundException {
        if (this.loader != null) {
            return this.loader.loadClass(className);
        }
        return ClassLoaderUtils.loadClass(className, callingClass);
    }

    @Override
    public InputStream getResourceAsStream(String resourceName) {
        if (this.loader != null) {
            return this.loader.getResourceAsStream(resourceName);
        }
        return ClassLoaderUtils.getResourceAsStream(resourceName, this.getClass());
    }

    @Override
    public void close() {
        if (this.loader != null && PluginsClassLoader.class.isAssignableFrom(this.loader.getClass())) {
            ((PluginsClassLoader)this.loader).close();
        }
    }
}

