/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.plugins.classloader;

import com.zutubi.plugins.classloader.BytesURLStreamHandler;
import com.zutubi.plugins.classloader.PluginsClassLoader;
import com.zutubi.plugins.utils.IOUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;

public class JarClassLoader
extends PluginsClassLoader {
    private JarFile jar;
    private File file;

    public JarClassLoader(File file, ClassLoader parent) {
        super(parent);
        this.file = file;
    }

    protected URL getDataURL(String name, byte[] data) throws MalformedURLException {
        return new URL(null, this.file.toURI().toURL().toExternalForm() + '!' + name, new BytesURLStreamHandler(data));
    }

    private void openJar() throws IOException {
        if (this.jar == null) {
            this.jar = new JarFile(this.file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized byte[] getFile(String path) {
        InputStream in = null;
        try {
            this.openJar();
            ZipEntry entry = this.jar.getEntry(path);
            if (entry == null) {
                byte[] byArray = null;
                return byArray;
            }
            in = this.jar.getInputStream(entry);
            int size = (int)entry.getSize();
            byte[] byArray = JarClassLoader.readStream(in, size);
            IOUtils.close(in);
            return byArray;
        }
        catch (IOException e) {
            byte[] byArray = null;
            return byArray;
        }
        finally {
            IOUtils.close(in);
        }
    }

    public Object clone() {
        JarClassLoader loader = new JarClassLoader(this.file, this.getParent());
        loader.packages = this.packages;
        return loader;
    }

    public void close() {
        try {
            if (this.jar != null) {
                this.jar.close();
            }
            this.jar = null;
        }
        catch (IOException e) {
            System.err.println("Error closing JAR: " + e);
        }
    }
}

