/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.i18n.error;

import com.zutubi.i18n.error.ErrorCode;
import com.zutubi.i18n.error.ErrorHandler;
import java.lang.reflect.Field;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Errors {
    private static ErrorHandler handler;

    private static synchronized ErrorHandler handler() {
        if (handler == null) {
            handler = new ErrorHandler();
        }
        return handler;
    }

    public static String error(ErrorCode errorCode) {
        return Errors.handler().error(errorCode);
    }

    public static boolean validateErrorCodes(Class classToCheck) {
        return Errors.validateErrorCodes(classToCheck, new HashSet<Integer>());
    }

    public static boolean validateErrorCodes(Class[] classesToCheck) {
        boolean result = true;
        HashSet<Integer> codes = new HashSet<Integer>();
        for (Class toCheck : classesToCheck) {
            if (Errors.validateErrorCodes(toCheck, codes)) continue;
            result = false;
            break;
        }
        return result;
    }

    private static boolean validateErrorCodes(Class toCheck, Set<Integer> codes) {
        boolean result = true;
        for (Field field : toCheck.getDeclaredFields()) {
            if (!field.getType().equals(ErrorCode.class)) continue;
            try {
                ErrorCode error = (ErrorCode)field.get(toCheck);
                int code = error.getCode();
                if (codes.contains(code)) {
                    result = false;
                    break;
                }
                codes.add(code);
            }
            catch (IllegalAccessException e) {
                // empty catch block
            }
        }
        return result;
    }
}

