/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.ssh2.signature;

import ch.ethz.ssh2.crypto.SimpleDERReader;
import ch.ethz.ssh2.crypto.digest.SHA1;
import ch.ethz.ssh2.log.Logger;
import ch.ethz.ssh2.packets.TypesReader;
import ch.ethz.ssh2.packets.TypesWriter;
import ch.ethz.ssh2.signature.RSAPrivateKey;
import ch.ethz.ssh2.signature.RSAPublicKey;
import ch.ethz.ssh2.signature.RSASignature;
import java.io.IOException;
import java.math.BigInteger;

public class RSASHA1Verify {
    private static final Logger log = Logger.getLogger(class$ch$ethz$ssh2$signature$RSASHA1Verify == null ? (class$ch$ethz$ssh2$signature$RSASHA1Verify = RSASHA1Verify.class$("ch.ethz.ssh2.signature.RSASHA1Verify")) : class$ch$ethz$ssh2$signature$RSASHA1Verify);
    static /* synthetic */ Class class$ch$ethz$ssh2$signature$RSASHA1Verify;

    public static RSAPublicKey decodeSSHRSAPublicKey(byte[] byArray) throws IOException {
        TypesReader typesReader = new TypesReader(byArray);
        String string = typesReader.readString();
        if (!string.equals("ssh-rsa")) {
            throw new IllegalArgumentException("This is not a ssh-rsa public key");
        }
        BigInteger bigInteger = typesReader.readMPINT();
        BigInteger bigInteger2 = typesReader.readMPINT();
        if (typesReader.remain() != 0) {
            throw new IOException("Padding in RSA public key!");
        }
        return new RSAPublicKey(bigInteger, bigInteger2);
    }

    public static byte[] encodeSSHRSAPublicKey(RSAPublicKey rSAPublicKey) throws IOException {
        TypesWriter typesWriter = new TypesWriter();
        typesWriter.writeString("ssh-rsa");
        typesWriter.writeMPInt(rSAPublicKey.getE());
        typesWriter.writeMPInt(rSAPublicKey.getN());
        return typesWriter.getBytes();
    }

    public static RSASignature decodeSSHRSASignature(byte[] byArray) throws IOException {
        TypesReader typesReader = new TypesReader(byArray);
        String string = typesReader.readString();
        if (!string.equals("ssh-rsa")) {
            throw new IOException("Peer sent wrong signature format");
        }
        byte[] byArray2 = typesReader.readByteString();
        if (byArray2.length == 0) {
            throw new IOException("Error in RSA signature, S is empty.");
        }
        if (log.isEnabled()) {
            log.log(80, "Decoding ssh-rsa signature string (length: " + byArray2.length + ")");
        }
        if (typesReader.remain() != 0) {
            throw new IOException("Padding in RSA signature!");
        }
        return new RSASignature(new BigInteger(1, byArray2));
    }

    public static byte[] encodeSSHRSASignature(RSASignature rSASignature) throws IOException {
        TypesWriter typesWriter = new TypesWriter();
        typesWriter.writeString("ssh-rsa");
        byte[] byArray = rSASignature.getS().toByteArray();
        if (byArray.length > 1 && byArray[0] == 0) {
            typesWriter.writeString(byArray, 1, byArray.length - 1);
        } else {
            typesWriter.writeString(byArray, 0, byArray.length);
        }
        return typesWriter.getBytes();
    }

    public static RSASignature generateSignature(byte[] byArray, RSAPrivateKey rSAPrivateKey) throws IOException {
        SHA1 sHA1 = new SHA1();
        sHA1.update(byArray);
        byte[] byArray2 = new byte[sHA1.getDigestLength()];
        sHA1.digest(byArray2);
        byte[] byArray3 = new byte[]{48, 33, 48, 9, 6, 5, 43, 14, 3, 2, 26, 5, 0, 4, 20};
        int n = (rSAPrivateKey.getN().bitLength() + 7) / 8;
        int n2 = n - (2 + byArray3.length + byArray2.length) - 1;
        if (n2 < 8) {
            throw new IOException("Cannot sign with RSA, message too long");
        }
        byte[] byArray4 = new byte[byArray3.length + byArray2.length + 2 + n2];
        byArray4[0] = 1;
        for (int i = 0; i < n2; ++i) {
            byArray4[i + 1] = -1;
        }
        byArray4[n2 + 1] = 0;
        System.arraycopy(byArray3, 0, byArray4, 2 + n2, byArray3.length);
        System.arraycopy(byArray2, 0, byArray4, 2 + n2 + byArray3.length, byArray2.length);
        BigInteger bigInteger = new BigInteger(1, byArray4);
        BigInteger bigInteger2 = bigInteger.modPow(rSAPrivateKey.getD(), rSAPrivateKey.getN());
        return new RSASignature(bigInteger2);
    }

    public static boolean verifySignature(byte[] byArray, RSASignature rSASignature, RSAPublicKey rSAPublicKey) throws IOException {
        SHA1 sHA1 = new SHA1();
        sHA1.update(byArray);
        byte[] byArray2 = new byte[sHA1.getDigestLength()];
        sHA1.digest(byArray2);
        BigInteger bigInteger = rSAPublicKey.getN();
        BigInteger bigInteger2 = rSAPublicKey.getE();
        BigInteger bigInteger3 = rSASignature.getS();
        if (bigInteger.compareTo(bigInteger3) <= 0) {
            log.log(20, "ssh-rsa signature: n.compareTo(s) <= 0");
            return false;
        }
        int n = (bigInteger.bitLength() + 7) / 8;
        if (n < 1) {
            log.log(20, "ssh-rsa signature: rsa_block_len < 1");
            return false;
        }
        byte[] byArray3 = bigInteger3.modPow(bigInteger2, bigInteger).toByteArray();
        int n2 = 0;
        if (byArray3.length > 0 && byArray3[0] == 0) {
            ++n2;
        }
        if (byArray3.length - n2 != n - 1) {
            log.log(20, "ssh-rsa signature: (v.length - startpos) != (rsa_block_len - 1)");
            return false;
        }
        if (byArray3[n2] != 1) {
            log.log(20, "ssh-rsa signature: v[startpos] != 0x01");
            return false;
        }
        int n3 = n2 + 1;
        while (true) {
            if (n3 >= byArray3.length) {
                log.log(20, "ssh-rsa signature: pos >= v.length");
                return false;
            }
            if (byArray3[n3] == 0) break;
            if (byArray3[n3] != -1) {
                log.log(20, "ssh-rsa signature: v[pos] != (byte) 0xff");
                return false;
            }
            ++n3;
        }
        int n4 = n3 - (n2 + 1);
        if (n4 < 8) {
            log.log(20, "ssh-rsa signature: num_pad < 8");
            return false;
        }
        if (++n3 >= byArray3.length) {
            log.log(20, "ssh-rsa signature: pos >= v.length");
            return false;
        }
        SimpleDERReader simpleDERReader = new SimpleDERReader(byArray3, n3, byArray3.length - n3);
        byte[] byArray4 = simpleDERReader.readSequenceAsByteArray();
        if (simpleDERReader.available() != 0) {
            log.log(20, "ssh-rsa signature: dr.available() != 0");
            return false;
        }
        simpleDERReader.resetInput(byArray4);
        byte[] byArray5 = simpleDERReader.readSequenceAsByteArray();
        if (byArray5.length < 8 || byArray5.length > 9) {
            log.log(20, "ssh-rsa signature: (digestAlgorithm.length < 8) || (digestAlgorithm.length > 9)");
            return false;
        }
        byte[] byArray6 = new byte[]{6, 5, 43, 14, 3, 2, 26, 5, 0};
        for (int i = 0; i < byArray5.length; ++i) {
            if (byArray5[i] == byArray6[i]) continue;
            log.log(20, "ssh-rsa signature: digestAlgorithm[i] != digestAlgorithm_sha1[i]");
            return false;
        }
        byte[] byArray7 = simpleDERReader.readOctetString();
        if (simpleDERReader.available() != 0) {
            log.log(20, "ssh-rsa signature: dr.available() != 0 (II)");
            return false;
        }
        if (byArray7.length != byArray2.length) {
            log.log(20, "ssh-rsa signature: digest.length != sha_message.length");
            return false;
        }
        for (int i = 0; i < byArray2.length; ++i) {
            if (byArray2[i] == byArray7[i]) continue;
            log.log(20, "ssh-rsa signature: sha_message[i] != digest[i]");
            return false;
        }
        return true;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

