/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.ssh2.packets;

import java.math.BigInteger;

public class TypesWriter {
    byte[] arr = new byte[256];
    int pos = 0;

    private void resize(int n) {
        byte[] byArray = new byte[n];
        System.arraycopy(this.arr, 0, byArray, 0, this.arr.length);
        this.arr = byArray;
    }

    public int length() {
        return this.pos;
    }

    public byte[] getBytes() {
        byte[] byArray = new byte[this.pos];
        System.arraycopy(this.arr, 0, byArray, 0, this.pos);
        return byArray;
    }

    public void getBytes(byte[] byArray) {
        System.arraycopy(this.arr, 0, byArray, 0, this.pos);
    }

    public void writeUINT32(int n, int n2) {
        if (n2 + 4 > this.arr.length) {
            this.resize(n2 + 32);
        }
        this.arr[n2++] = (byte)(n >> 24);
        this.arr[n2++] = (byte)(n >> 16);
        this.arr[n2++] = (byte)(n >> 8);
        this.arr[n2++] = (byte)n;
    }

    public void writeUINT32(int n) {
        this.writeUINT32(n, this.pos);
        this.pos += 4;
    }

    public void writeUINT64(long l) {
        if (this.pos + 8 > this.arr.length) {
            this.resize(this.arr.length + 32);
        }
        this.arr[this.pos++] = (byte)(l >> 56);
        this.arr[this.pos++] = (byte)(l >> 48);
        this.arr[this.pos++] = (byte)(l >> 40);
        this.arr[this.pos++] = (byte)(l >> 32);
        this.arr[this.pos++] = (byte)(l >> 24);
        this.arr[this.pos++] = (byte)(l >> 16);
        this.arr[this.pos++] = (byte)(l >> 8);
        this.arr[this.pos++] = (byte)l;
    }

    public void writeBoolean(boolean bl) {
        if (this.pos + 1 > this.arr.length) {
            this.resize(this.arr.length + 32);
        }
        this.arr[this.pos++] = bl ? (byte)1 : 0;
    }

    public void writeByte(int n, int n2) {
        if (n2 + 1 > this.arr.length) {
            this.resize(n2 + 32);
        }
        this.arr[n2] = (byte)n;
    }

    public void writeByte(int n) {
        this.writeByte(n, this.pos);
        ++this.pos;
    }

    public void writeMPInt(BigInteger bigInteger) {
        byte[] byArray = bigInteger.toByteArray();
        if (byArray.length == 1 && byArray[0] == 0) {
            this.writeUINT32(0);
        } else {
            this.writeString(byArray, 0, byArray.length);
        }
    }

    public void writeBytes(byte[] byArray, int n, int n2) {
        if (this.pos + n2 > this.arr.length) {
            this.resize(this.arr.length + n2 + 32);
        }
        System.arraycopy(byArray, n, this.arr, this.pos, n2);
        this.pos += n2;
    }

    public void writeString(byte[] byArray, int n, int n2) {
        this.writeUINT32(n2);
        this.writeBytes(byArray, n, n2);
    }

    public void writeString(String string) {
        byte[] byArray = string.getBytes();
        this.writeUINT32(byArray.length);
        this.writeBytes(byArray, 0, byArray.length);
    }

    public void writeNameList(String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < stringArray.length; ++i) {
            if (i > 0) {
                stringBuffer.append(',');
            }
            stringBuffer.append(stringArray[i]);
        }
        this.writeString(stringBuffer.toString());
    }
}

