/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.ssh2.packets;

import ch.ethz.ssh2.packets.TypesReader;
import java.io.IOException;

public class PacketUserauthInfoRequest {
    byte[] payload;
    String name;
    String instruction;
    String languageTag;
    int numPrompts;
    String[] prompt;
    boolean[] echo;

    public PacketUserauthInfoRequest(byte[] byArray, int n, int n2) throws IOException {
        this.payload = new byte[n2];
        System.arraycopy(byArray, n, this.payload, 0, n2);
        TypesReader typesReader = new TypesReader(byArray, n, n2);
        int n3 = typesReader.readByte();
        if (n3 != 60) {
            throw new IOException("This is not a SSH_MSG_USERAUTH_INFO_REQUEST! (" + n3 + ")");
        }
        this.name = typesReader.readString();
        this.instruction = typesReader.readString();
        this.languageTag = typesReader.readString();
        this.numPrompts = typesReader.readUINT32();
        this.prompt = new String[this.numPrompts];
        this.echo = new boolean[this.numPrompts];
        for (int i = 0; i < this.numPrompts; ++i) {
            this.prompt[i] = typesReader.readString();
            this.echo[i] = typesReader.readBoolean();
        }
        if (typesReader.remain() != 0) {
            throw new IOException("Padding in SSH_MSG_USERAUTH_INFO_REQUEST packet!");
        }
    }

    public boolean[] getEcho() {
        return this.echo;
    }

    public String getInstruction() {
        return this.instruction;
    }

    public String getLanguageTag() {
        return this.languageTag;
    }

    public String getName() {
        return this.name;
    }

    public int getNumPrompts() {
        return this.numPrompts;
    }

    public String[] getPrompt() {
        return this.prompt;
    }
}

