/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.ssh2.packets;

import ch.ethz.ssh2.packets.TypesReader;
import ch.ethz.ssh2.packets.TypesWriter;
import java.io.IOException;

public class PacketServiceRequest {
    byte[] payload;
    String serviceName;

    public PacketServiceRequest(String string) {
        this.serviceName = string;
    }

    public PacketServiceRequest(byte[] byArray, int n, int n2) throws IOException {
        this.payload = new byte[n2];
        System.arraycopy(byArray, n, this.payload, 0, n2);
        TypesReader typesReader = new TypesReader(byArray, n, n2);
        int n3 = typesReader.readByte();
        if (n3 != 5) {
            throw new IOException("This is not a SSH_MSG_SERVICE_REQUEST! (" + n3 + ")");
        }
        this.serviceName = typesReader.readString();
        if (typesReader.remain() != 0) {
            throw new IOException("Padding in SSH_MSG_SERVICE_REQUEST packet!");
        }
    }

    public byte[] getPayload() {
        if (this.payload == null) {
            TypesWriter typesWriter = new TypesWriter();
            typesWriter.writeByte(5);
            typesWriter.writeString(this.serviceName);
            this.payload = typesWriter.getBytes();
        }
        return this.payload;
    }
}

