/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.ssh2.packets;

import ch.ethz.ssh2.packets.TypesReader;
import ch.ethz.ssh2.packets.TypesWriter;
import java.io.IOException;

public class PacketServiceAccept {
    byte[] payload;
    String serviceName;

    public PacketServiceAccept(String string) {
        this.serviceName = string;
    }

    public PacketServiceAccept(byte[] byArray, int n, int n2) throws IOException {
        this.payload = new byte[n2];
        System.arraycopy(byArray, n, this.payload, 0, n2);
        TypesReader typesReader = new TypesReader(byArray, n, n2);
        int n3 = typesReader.readByte();
        if (n3 != 6) {
            throw new IOException("This is not a SSH_MSG_SERVICE_ACCEPT! (" + n3 + ")");
        }
        this.serviceName = typesReader.readString();
        if (typesReader.remain() != 0) {
            throw new IOException("Padding in SSH_MSG_SERVICE_ACCEPT packet!");
        }
    }

    public byte[] getPayload() {
        if (this.payload == null) {
            TypesWriter typesWriter = new TypesWriter();
            typesWriter.writeByte(6);
            typesWriter.writeString(this.serviceName);
            this.payload = typesWriter.getBytes();
        }
        return this.payload;
    }
}

