/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.ssh2.packets;

import ch.ethz.ssh2.packets.TypesReader;
import java.io.IOException;
import java.math.BigInteger;

public class PacketKexDHReply {
    byte[] payload;
    byte[] hostKey;
    BigInteger f;
    byte[] signature;

    public PacketKexDHReply(byte[] byArray, int n, int n2) throws IOException {
        this.payload = new byte[n2];
        System.arraycopy(byArray, n, this.payload, 0, n2);
        TypesReader typesReader = new TypesReader(byArray, n, n2);
        int n3 = typesReader.readByte();
        if (n3 != 31) {
            throw new IOException("This is not a SSH_MSG_KEXDH_REPLY! (" + n3 + ")");
        }
        this.hostKey = typesReader.readByteString();
        this.f = typesReader.readMPINT();
        this.signature = typesReader.readByteString();
        if (typesReader.remain() != 0) {
            throw new IOException("PADDING IN SSH_MSG_KEXDH_REPLY!");
        }
    }

    public BigInteger getF() {
        return this.f;
    }

    public byte[] getHostKey() {
        return this.hostKey;
    }

    public byte[] getSignature() {
        return this.signature;
    }
}

