/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.ssh2.packets;

import ch.ethz.ssh2.packets.TypesReader;
import ch.ethz.ssh2.packets.TypesWriter;
import java.io.IOException;

public class PacketChannelWindowAdjust {
    byte[] payload;
    public int recipientChannelID;
    public int windowChange;

    public PacketChannelWindowAdjust(int n, int n2) {
        this.recipientChannelID = n;
        this.windowChange = n2;
    }

    public PacketChannelWindowAdjust(byte[] byArray, int n, int n2) throws IOException {
        this.payload = new byte[n2];
        System.arraycopy(byArray, n, this.payload, 0, n2);
        TypesReader typesReader = new TypesReader(byArray, n, n2);
        int n3 = typesReader.readByte();
        if (n3 != 93) {
            throw new IOException("This is not a SSH_MSG_CHANNEL_WINDOW_ADJUST! (" + n3 + ")");
        }
        this.recipientChannelID = typesReader.readUINT32();
        this.windowChange = typesReader.readUINT32();
        if (typesReader.remain() != 0) {
            throw new IOException("Padding in SSH_MSG_CHANNEL_WINDOW_ADJUST packet!");
        }
    }

    public byte[] getPayload() {
        if (this.payload == null) {
            TypesWriter typesWriter = new TypesWriter();
            typesWriter.writeByte(93);
            typesWriter.writeUINT32(this.recipientChannelID);
            typesWriter.writeUINT32(this.windowChange);
            this.payload = typesWriter.getBytes();
        }
        return this.payload;
    }
}

