/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.ssh2.packets;

import ch.ethz.ssh2.packets.TypesReader;
import ch.ethz.ssh2.packets.TypesWriter;
import java.io.IOException;

public class PacketChannelOpenConfirmation {
    byte[] payload;
    public int recipientChannelID;
    public int senderChannelID;
    public int initialWindowSize;
    public int maxPacketSize;

    public PacketChannelOpenConfirmation(int n, int n2, int n3, int n4) {
        this.recipientChannelID = n;
        this.senderChannelID = n2;
        this.initialWindowSize = n3;
        this.maxPacketSize = n4;
    }

    public PacketChannelOpenConfirmation(byte[] byArray, int n, int n2) throws IOException {
        this.payload = new byte[n2];
        System.arraycopy(byArray, n, this.payload, 0, n2);
        TypesReader typesReader = new TypesReader(byArray, n, n2);
        int n3 = typesReader.readByte();
        if (n3 != 91) {
            throw new IOException("This is not a SSH_MSG_CHANNEL_OPEN_CONFIRMATION! (" + n3 + ")");
        }
        this.recipientChannelID = typesReader.readUINT32();
        this.senderChannelID = typesReader.readUINT32();
        this.initialWindowSize = typesReader.readUINT32();
        this.maxPacketSize = typesReader.readUINT32();
        if (typesReader.remain() != 0) {
            throw new IOException("Padding in SSH_MSG_CHANNEL_OPEN_CONFIRMATION packet!");
        }
    }

    public byte[] getPayload() {
        if (this.payload == null) {
            TypesWriter typesWriter = new TypesWriter();
            typesWriter.writeByte(91);
            typesWriter.writeUINT32(this.recipientChannelID);
            typesWriter.writeUINT32(this.senderChannelID);
            typesWriter.writeUINT32(this.initialWindowSize);
            typesWriter.writeUINT32(this.maxPacketSize);
            this.payload = typesWriter.getBytes();
        }
        return this.payload;
    }
}

