/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.ssh2.crypto.digest;

import ch.ethz.ssh2.crypto.digest.Digest;

public class SHA1
implements Digest {
    private int H0;
    private int H1;
    private int H2;
    private int H3;
    private int H4;
    private final byte[] msg = new byte[64];
    private final int[] w = new int[80];
    private int currentPos;
    private long currentLen;

    public SHA1() {
        this.reset();
    }

    public final int getDigestLength() {
        return 20;
    }

    public void reset() {
        this.H0 = 1732584193;
        this.H1 = -271733879;
        this.H2 = -1732584194;
        this.H3 = 271733878;
        this.H4 = -1009589776;
        this.currentPos = 0;
        this.currentLen = 0L;
    }

    public final void update(byte[] byArray, int n, int n2) {
        for (int i = n; i < n + n2; ++i) {
            this.update(byArray[i]);
        }
    }

    public final void update(byte[] byArray) {
        for (int i = 0; i < byArray.length; ++i) {
            this.update(byArray[i]);
        }
    }

    public final void update(byte by) {
        this.msg[this.currentPos++] = by;
        this.currentLen += 8L;
        if (this.currentPos == 64) {
            this.perform();
            this.currentPos = 0;
        }
    }

    private static final String toHexString(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < byArray.length; ++i) {
            stringBuffer.append("0123456789ABCDEF".charAt(byArray[i] >> 4 & 0xF));
            stringBuffer.append("0123456789ABCDEF".charAt(byArray[i] & 0xF));
        }
        return stringBuffer.toString();
    }

    private final void putInt(byte[] byArray, int n, int n2) {
        byArray[n] = (byte)(n2 >> 24);
        byArray[n + 1] = (byte)(n2 >> 16);
        byArray[n + 2] = (byte)(n2 >> 8);
        byArray[n + 3] = (byte)n2;
    }

    public final void digest(byte[] byArray) {
        this.digest(byArray, 0);
    }

    public final void digest(byte[] byArray, int n) {
        long l = this.currentLen;
        this.update((byte)-128);
        while (this.currentPos != 56) {
            this.update((byte)0);
        }
        this.update((byte)(l >> 56));
        this.update((byte)(l >> 48));
        this.update((byte)(l >> 40));
        this.update((byte)(l >> 32));
        this.update((byte)(l >> 24));
        this.update((byte)(l >> 16));
        this.update((byte)(l >> 8));
        this.update((byte)l);
        this.putInt(byArray, n, this.H0);
        this.putInt(byArray, n + 4, this.H1);
        this.putInt(byArray, n + 8, this.H2);
        this.putInt(byArray, n + 12, this.H3);
        this.putInt(byArray, n + 16, this.H4);
        this.reset();
    }

    private final void perform() {
        int n;
        int n2;
        int n3;
        int n4;
        for (n4 = 0; n4 < 16; ++n4) {
            this.w[n4] = (this.msg[n4 * 4] & 0xFF) << 24 | (this.msg[n4 * 4 + 1] & 0xFF) << 16 | (this.msg[n4 * 4 + 2] & 0xFF) << 8 | this.msg[n4 * 4 + 3] & 0xFF;
        }
        for (n4 = 16; n4 < 80; ++n4) {
            n3 = this.w[n4 - 3] ^ this.w[n4 - 8] ^ this.w[n4 - 14] ^ this.w[n4 - 16];
            this.w[n4] = n3 << 1 | n3 >>> 31;
        }
        n4 = this.H0;
        n3 = this.H1;
        int n5 = this.H2;
        int n6 = this.H3;
        int n7 = this.H4;
        for (n2 = 0; n2 <= 19; ++n2) {
            n = (n4 << 5 | n4 >>> 27) + (n3 & n5 | ~n3 & n6) + n7 + this.w[n2] + 1518500249;
            n7 = n6;
            n6 = n5;
            n5 = n3 << 30 | n3 >>> 2;
            n3 = n4;
            n4 = n;
        }
        for (n2 = 20; n2 <= 39; ++n2) {
            n = (n4 << 5 | n4 >>> 27) + (n3 ^ n5 ^ n6) + n7 + this.w[n2] + 1859775393;
            n7 = n6;
            n6 = n5;
            n5 = n3 << 30 | n3 >>> 2;
            n3 = n4;
            n4 = n;
        }
        for (n2 = 40; n2 <= 59; ++n2) {
            n = (n4 << 5 | n4 >>> 27) + (n3 & n5 | n3 & n6 | n5 & n6) + n7 + this.w[n2] + -1894007588;
            n7 = n6;
            n6 = n5;
            n5 = n3 << 30 | n3 >>> 2;
            n3 = n4;
            n4 = n;
        }
        for (n2 = 60; n2 <= 79; ++n2) {
            n = (n4 << 5 | n4 >>> 27) + (n3 ^ n5 ^ n6) + n7 + this.w[n2] + -899497514;
            n7 = n6;
            n6 = n5;
            n5 = n3 << 30 | n3 >>> 2;
            n3 = n4;
            n4 = n;
        }
        this.H0 += n4;
        this.H1 += n3;
        this.H2 += n5;
        this.H3 += n6;
        this.H4 += n7;
    }

    public static void main(String[] stringArray) {
        SHA1 sHA1 = new SHA1();
        byte[] byArray = new byte[20];
        byte[] byArray2 = new byte[20];
        byte[] byArray3 = new byte[20];
        sHA1.update("abc".getBytes());
        sHA1.digest(byArray);
        sHA1.update("abcdbcdecdefdefgefghfghighijhijkijkljklmklmnlmnomnopnopq".getBytes());
        sHA1.digest(byArray2);
        for (int i = 0; i < 1000000; ++i) {
            sHA1.update((byte)97);
        }
        sHA1.digest(byArray3);
        String string = SHA1.toHexString(byArray);
        String string2 = SHA1.toHexString(byArray2);
        String string3 = SHA1.toHexString(byArray3);
        String string4 = "A9993E364706816ABA3E25717850C26C9CD0D89D";
        String string5 = "84983E441C3BD26EBAAE4AA1F95129E5E54670F1";
        String string6 = "34AA973CD4C4DAA4F61EEB2BDBAD27316534016F";
        if (string.equals(string4)) {
            System.out.println("SHA-1 Test 1 OK.");
        } else {
            System.out.println("SHA-1 Test 1 FAILED.");
        }
        if (string2.equals(string5)) {
            System.out.println("SHA-1 Test 2 OK.");
        } else {
            System.out.println("SHA-1 Test 2 FAILED.");
        }
        if (string3.equals(string6)) {
            System.out.println("SHA-1 Test 3 OK.");
        } else {
            System.out.println("SHA-1 Test 3 FAILED.");
        }
    }
}

