/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.ssh2.crypto.digest;

import ch.ethz.ssh2.crypto.digest.Digest;

public class HMAC
implements Digest {
    Digest md;
    byte[] k_xor_ipad;
    byte[] k_xor_opad;
    byte[] tmp;
    int size;

    public HMAC(Digest digest, byte[] byArray, int n) {
        this.md = digest;
        this.size = n;
        this.tmp = new byte[digest.getDigestLength()];
        int n2 = 64;
        this.k_xor_ipad = new byte[n2];
        this.k_xor_opad = new byte[n2];
        if (byArray.length > n2) {
            digest.reset();
            digest.update(byArray);
            digest.digest(this.tmp);
            byArray = this.tmp;
        }
        System.arraycopy(byArray, 0, this.k_xor_ipad, 0, byArray.length);
        System.arraycopy(byArray, 0, this.k_xor_opad, 0, byArray.length);
        int n3 = 0;
        while (n3 < n2) {
            int n4 = n3;
            this.k_xor_ipad[n4] = (byte)(this.k_xor_ipad[n4] ^ 0x36);
            int n5 = n3++;
            this.k_xor_opad[n5] = (byte)(this.k_xor_opad[n5] ^ 0x5C);
        }
        digest.update(this.k_xor_ipad);
    }

    public int getDigestLength() {
        return this.size;
    }

    public void update(byte by) {
        this.md.update(by);
    }

    public void update(byte[] byArray) {
        this.md.update(byArray);
    }

    public void update(byte[] byArray, int n, int n2) {
        this.md.update(byArray, n, n2);
    }

    public void reset() {
        this.md.reset();
        this.md.update(this.k_xor_ipad);
    }

    public void digest(byte[] byArray) {
        this.digest(byArray, 0);
    }

    public void digest(byte[] byArray, int n) {
        this.md.digest(this.tmp);
        this.md.update(this.k_xor_opad);
        this.md.update(this.tmp);
        this.md.digest(this.tmp);
        System.arraycopy(this.tmp, 0, byArray, n, this.size);
        this.md.update(this.k_xor_ipad);
    }
}

