/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.ssh2.crypto.dh;

import ch.ethz.ssh2.DHGexParameters;
import ch.ethz.ssh2.crypto.digest.HashForSSH2Types;
import java.math.BigInteger;
import java.security.SecureRandom;

public class DhGroupExchange {
    BigInteger p;
    BigInteger g;
    BigInteger e;
    BigInteger x;
    BigInteger f;
    BigInteger k;

    public DhGroupExchange(BigInteger bigInteger, BigInteger bigInteger2) {
        this.p = bigInteger;
        this.g = bigInteger2;
    }

    public void init() {
        this.k = null;
        this.x = new BigInteger(this.p.bitLength() - 1, new SecureRandom());
        this.e = this.g.modPow(this.x, this.p);
    }

    public BigInteger getE() {
        if (this.e == null) {
            throw new IllegalStateException("Not initialized!");
        }
        return this.e;
    }

    public BigInteger getK() {
        if (this.k == null) {
            throw new IllegalStateException("Shared secret not yet known, need f first!");
        }
        return this.k;
    }

    public void setF(BigInteger bigInteger) {
        if (this.e == null) {
            throw new IllegalStateException("Not initialized!");
        }
        BigInteger bigInteger2 = BigInteger.valueOf(0L);
        if (bigInteger2.compareTo(bigInteger) >= 0 || this.p.compareTo(bigInteger) <= 0) {
            throw new IllegalArgumentException("Invalid f specified!");
        }
        this.f = bigInteger;
        this.k = bigInteger.modPow(this.x, this.p);
    }

    public byte[] calculateH(byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4, byte[] byArray5, DHGexParameters dHGexParameters) {
        HashForSSH2Types hashForSSH2Types = new HashForSSH2Types("SHA1");
        hashForSSH2Types.updateByteString(byArray);
        hashForSSH2Types.updateByteString(byArray2);
        hashForSSH2Types.updateByteString(byArray3);
        hashForSSH2Types.updateByteString(byArray4);
        hashForSSH2Types.updateByteString(byArray5);
        hashForSSH2Types.updateUINT32(dHGexParameters.getMin_group_len());
        hashForSSH2Types.updateUINT32(dHGexParameters.getPref_group_len());
        hashForSSH2Types.updateUINT32(dHGexParameters.getMax_group_len());
        hashForSSH2Types.updateBigInt(this.p);
        hashForSSH2Types.updateBigInt(this.g);
        hashForSSH2Types.updateBigInt(this.e);
        hashForSSH2Types.updateBigInt(this.f);
        hashForSSH2Types.updateBigInt(this.k);
        return hashForSSH2Types.getDigest();
    }
}

