/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.ssh2.crypto.cipher;

import ch.ethz.ssh2.crypto.cipher.BlockCipher;
import java.io.IOException;
import java.io.InputStream;

public class CipherInputStream {
    BlockCipher currentCipher;
    InputStream bi;
    byte[] buffer;
    byte[] enc;
    int blockSize;
    int pos;
    final int BUFF_SIZE = 2048;
    byte[] input_buffer = new byte[2048];
    int input_buffer_pos = 0;
    int input_buffer_size = 0;

    public CipherInputStream(BlockCipher blockCipher, InputStream inputStream) {
        this.bi = inputStream;
        this.changeCipher(blockCipher);
    }

    private int fill_buffer() throws IOException {
        this.input_buffer_pos = 0;
        this.input_buffer_size = this.bi.read(this.input_buffer, 0, 2048);
        return this.input_buffer_size;
    }

    private int internal_read(byte[] byArray, int n, int n2) throws IOException {
        if (this.input_buffer_size < 0) {
            return -1;
        }
        if (this.input_buffer_pos >= this.input_buffer_size && this.fill_buffer() <= 0) {
            return -1;
        }
        int n3 = this.input_buffer_size - this.input_buffer_pos;
        int n4 = n2 > n3 ? n3 : n2;
        System.arraycopy(this.input_buffer, this.input_buffer_pos, byArray, n, n4);
        this.input_buffer_pos += n4;
        return n4;
    }

    private int internal_read() throws IOException {
        if (this.input_buffer_size < 0) {
            return -1;
        }
        if (this.input_buffer_pos >= this.input_buffer_size && this.fill_buffer() <= 0) {
            return -1;
        }
        return this.input_buffer[this.input_buffer_pos++] & 0xFF;
    }

    public void changeCipher(BlockCipher blockCipher) {
        this.currentCipher = blockCipher;
        this.blockSize = blockCipher.getBlockSize();
        this.buffer = new byte[this.blockSize];
        this.enc = new byte[this.blockSize];
        this.pos = this.blockSize;
    }

    private void getBlock() throws IOException {
        int n;
        for (int i = 0; i < this.blockSize; i += n) {
            n = this.internal_read(this.enc, i, this.blockSize - i);
            if (n >= 0) continue;
            throw new IOException("Cannot read full block, EOF reached.");
        }
        try {
            this.currentCipher.transformBlock(this.enc, 0, this.buffer, 0);
        }
        catch (Exception exception) {
            throw new IOException("Error while decrypting block.");
        }
        this.pos = 0;
    }

    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = 0;
        while (n2 > 0) {
            if (this.pos >= this.blockSize) {
                this.getBlock();
            }
            int n4 = this.blockSize - this.pos;
            int n5 = Math.min(n4, n2);
            System.arraycopy(this.buffer, this.pos, byArray, n, n5);
            this.pos += n5;
            n += n5;
            n2 -= n5;
            n3 += n5;
        }
        return n3;
    }

    public int read() throws IOException {
        if (this.pos >= this.blockSize) {
            this.getBlock();
        }
        return this.buffer[this.pos++] & 0xFF;
    }

    public int readPlain(int n) throws IOException {
        if (this.pos != this.blockSize) {
            throw new IOException("Cannot read plain since crypto buffer is not aligned.");
        }
        return this.internal_read();
    }

    public int readPlain(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        int n4;
        if (this.pos != this.blockSize) {
            throw new IOException("Cannot read plain since crypto buffer is not aligned.");
        }
        for (n3 = 0; n3 < n2; n3 += n4) {
            n4 = this.internal_read(byArray, n + n3, n2 - n3);
            if (n4 >= 0) continue;
            throw new IOException("Cannot fill buffer, EOF reached.");
        }
        return n3;
    }
}

