/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.ssh2.crypto.cipher;

import ch.ethz.ssh2.crypto.cipher.BlockCipher;

public class CTRMode
implements BlockCipher {
    byte[] X;
    byte[] Xenc;
    BlockCipher bc;
    int blockSize;
    boolean doEncrypt;
    int count = 0;

    public void init(boolean bl, byte[] byArray) {
    }

    public CTRMode(BlockCipher blockCipher, byte[] byArray, boolean bl) throws IllegalArgumentException {
        this.bc = blockCipher;
        this.blockSize = this.bc.getBlockSize();
        this.doEncrypt = bl;
        if (this.blockSize != byArray.length) {
            throw new IllegalArgumentException("IV must be " + this.blockSize + " bytes long! (currently " + byArray.length + ")");
        }
        this.X = new byte[this.blockSize];
        this.Xenc = new byte[this.blockSize];
        System.arraycopy(byArray, 0, this.X, 0, this.blockSize);
    }

    public final int getBlockSize() {
        return this.blockSize;
    }

    public final void transformBlock(byte[] byArray, int n, byte[] byArray2, int n2) {
        int n3;
        this.bc.transformBlock(this.X, 0, this.Xenc, 0);
        for (n3 = 0; n3 < this.blockSize; ++n3) {
            byArray2[n2 + n3] = (byte)(byArray[n + n3] ^ this.Xenc[n3]);
        }
        for (n3 = this.blockSize - 1; n3 >= 0; --n3) {
            int n4 = n3;
            this.X[n4] = (byte)(this.X[n4] + 1);
            if (this.X[n3] != 0) break;
        }
    }
}

