/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.ssh2.crypto;

import java.io.IOException;
import java.math.BigInteger;

public class SimpleDERReader {
    byte[] buffer;
    int pos;
    int count;

    public SimpleDERReader(byte[] byArray) {
        this.resetInput(byArray);
    }

    public SimpleDERReader(byte[] byArray, int n, int n2) {
        this.resetInput(byArray, n, n2);
    }

    public void resetInput(byte[] byArray) {
        this.resetInput(byArray, 0, byArray.length);
    }

    public void resetInput(byte[] byArray, int n, int n2) {
        this.buffer = byArray;
        this.pos = n;
        this.count = n2;
    }

    private byte readByte() throws IOException {
        if (this.count <= 0) {
            throw new IOException("DER byte array: out of data");
        }
        --this.count;
        return this.buffer[this.pos++];
    }

    private byte[] readBytes(int n) throws IOException {
        if (n > this.count) {
            throw new IOException("DER byte array: out of data");
        }
        byte[] byArray = new byte[n];
        System.arraycopy(this.buffer, this.pos, byArray, 0, n);
        this.pos += n;
        this.count -= n;
        return byArray;
    }

    public int available() {
        return this.count;
    }

    private int readLength() throws IOException {
        int n = this.readByte() & 0xFF;
        if ((n & 0x80) == 0) {
            return n;
        }
        int n2 = n & 0x7F;
        if (n2 == 0) {
            return -1;
        }
        n = 0;
        while (n2 > 0) {
            n <<= 8;
            n |= this.readByte() & 0xFF;
            --n2;
        }
        return n;
    }

    public int ignoreNextObject() throws IOException {
        int n = this.readByte() & 0xFF;
        int n2 = this.readLength();
        if (n2 < 0 || n2 > this.available()) {
            throw new IOException("Illegal len in DER object (" + n2 + ")");
        }
        this.readBytes(n2);
        return n;
    }

    public BigInteger readInt() throws IOException {
        int n = this.readByte() & 0xFF;
        if (n != 2) {
            throw new IOException("Expected DER Integer, but found type " + n);
        }
        int n2 = this.readLength();
        if (n2 < 0 || n2 > this.available()) {
            throw new IOException("Illegal len in DER object (" + n2 + ")");
        }
        byte[] byArray = this.readBytes(n2);
        BigInteger bigInteger = new BigInteger(byArray);
        return bigInteger;
    }

    public byte[] readSequenceAsByteArray() throws IOException {
        int n = this.readByte() & 0xFF;
        if (n != 48) {
            throw new IOException("Expected DER Sequence, but found type " + n);
        }
        int n2 = this.readLength();
        if (n2 < 0 || n2 > this.available()) {
            throw new IOException("Illegal len in DER object (" + n2 + ")");
        }
        byte[] byArray = this.readBytes(n2);
        return byArray;
    }

    public byte[] readOctetString() throws IOException {
        int n = this.readByte() & 0xFF;
        if (n != 4) {
            throw new IOException("Expected DER Sequence, but found type " + n);
        }
        int n2 = this.readLength();
        if (n2 < 0 || n2 > this.available()) {
            throw new IOException("Illegal len in DER object (" + n2 + ")");
        }
        byte[] byArray = this.readBytes(n2);
        return byArray;
    }
}

